// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Resource Operation.
 */
public class ResourceOperation extends Entity implements IJsonBackedObject {


    /**
     * The Action Name.
     * Type of action this operation is going to perform. The actionName should be concise and limited to as few words as possible.
     */
    @SerializedName(value = "actionName", alternate = {"ActionName"})
    @Expose
	@Nullable
    public String actionName;

    /**
     * The Description.
     * Description of the resource operation. The description is used in mouse-over text for the operation when shown in the Azure Portal.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Resource Name.
     * Name of the Resource this operation is performed on.
     */
    @SerializedName(value = "resourceName", alternate = {"ResourceName"})
    @Expose
	@Nullable
    public String resourceName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
