// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Schedule Change Request Decline Parameter Set.
 */
public class ScheduleChangeRequestDeclineParameterSet {
    /**
     * The message.
     * 
     */
    @SerializedName(value = "message", alternate = {"Message"})
    @Expose
	@Nullable
    public String message;


    /**
     * Instiaciates a new ScheduleChangeRequestDeclineParameterSet
     */
    public ScheduleChangeRequestDeclineParameterSet() {}
    /**
     * Instiaciates a new ScheduleChangeRequestDeclineParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ScheduleChangeRequestDeclineParameterSet(@Nonnull final ScheduleChangeRequestDeclineParameterSetBuilder builder) {
        this.message = builder.message;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ScheduleChangeRequestDeclineParameterSetBuilder newBuilder() {
        return new ScheduleChangeRequestDeclineParameterSetBuilder();
    }
    /**
     * Fluent builder for the ScheduleChangeRequestDeclineParameterSet
     */
    public static final class ScheduleChangeRequestDeclineParameterSetBuilder {
        /**
         * The message parameter value
         */
        @Nullable
        protected String message;
        /**
         * Sets the Message
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ScheduleChangeRequestDeclineParameterSetBuilder withMessage(@Nullable final String val) {
            this.message = val;
            return this;
        }
        /**
         * Instanciates a new ScheduleChangeRequestDeclineParameterSetBuilder
         */
        @Nullable
        protected ScheduleChangeRequestDeclineParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ScheduleChangeRequestDeclineParameterSet build() {
            return new ScheduleChangeRequestDeclineParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.message != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("message", message));
        }
        return result;
    }
}
