// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Progress.
 */
public class SynchronizationProgress implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Completed Units.
     * The numerator of a progress ratio; the number of units of changes already processed.
     */
    @SerializedName(value = "completedUnits", alternate = {"CompletedUnits"})
    @Expose
	@Nullable
    public Long completedUnits;

    /**
     * The Progress Observation Date Time.
     * The time of a progress observation as an offset in minutes from UTC.
     */
    @SerializedName(value = "progressObservationDateTime", alternate = {"ProgressObservationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime progressObservationDateTime;

    /**
     * The Total Units.
     * The denominator of a progress ratio; a number of units of changes to be processed to accomplish synchronization.
     */
    @SerializedName(value = "totalUnits", alternate = {"TotalUnits"})
    @Expose
	@Nullable
    public Long totalUnits;

    /**
     * The Units.
     * An optional description of the units.
     */
    @SerializedName(value = "units", alternate = {"Units"})
    @Expose
	@Nullable
    public String units;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
