// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.SynchronizationStatusCode;
import com.microsoft.graph.models.SynchronizationTaskExecution;
import com.microsoft.graph.models.SynchronizationProgress;
import com.microsoft.graph.models.SynchronizationQuarantine;
import com.microsoft.graph.models.StringKeyLongValuePair;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Status.
 */
public class SynchronizationStatus implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Code.
     * High-level status code of the synchronization job. Possible values are: NotConfigured, NotRun, Active, Paused, Quarantine.
     */
    @SerializedName(value = "code", alternate = {"Code"})
    @Expose
	@Nullable
    public SynchronizationStatusCode code;

    /**
     * The Count Successive Complete Failures.
     * Number of consecutive times this job failed.
     */
    @SerializedName(value = "countSuccessiveCompleteFailures", alternate = {"CountSuccessiveCompleteFailures"})
    @Expose
	@Nullable
    public Long countSuccessiveCompleteFailures;

    /**
     * The Escrows Pruned.
     * true if the job's escrows (object-level errors) were pruned during initial synchronization. Escrows can be pruned if during the initial synchronization, you reach the threshold of errors that would normally put the job in quarantine. Instead of going into quarantine, the synchronization process clears the job's errors and continues until the initial synchronization is completed. When the initial synchronization is completed, the job will pause and wait for the customer to clean up the errors.
     */
    @SerializedName(value = "escrowsPruned", alternate = {"EscrowsPruned"})
    @Expose
	@Nullable
    public Boolean escrowsPruned;

    /**
     * The Last Execution.
     * Details of the last execution of the job.
     */
    @SerializedName(value = "lastExecution", alternate = {"LastExecution"})
    @Expose
	@Nullable
    public SynchronizationTaskExecution lastExecution;

    /**
     * The Last Successful Execution.
     * Details of the last execution of this job, which didn't have any errors.
     */
    @SerializedName(value = "lastSuccessfulExecution", alternate = {"LastSuccessfulExecution"})
    @Expose
	@Nullable
    public SynchronizationTaskExecution lastSuccessfulExecution;

    /**
     * The Last Successful Execution With Exports.
     * Details of the last execution of the job, which exported objects into the target directory.
     */
    @SerializedName(value = "lastSuccessfulExecutionWithExports", alternate = {"LastSuccessfulExecutionWithExports"})
    @Expose
	@Nullable
    public SynchronizationTaskExecution lastSuccessfulExecutionWithExports;

    /**
     * The Progress.
     * Details of the progress of a job toward completion.
     */
    @SerializedName(value = "progress", alternate = {"Progress"})
    @Expose
	@Nullable
    public java.util.List<SynchronizationProgress> progress;

    /**
     * The Quarantine.
     * If job is in quarantine, quarantine details.
     */
    @SerializedName(value = "quarantine", alternate = {"Quarantine"})
    @Expose
	@Nullable
    public SynchronizationQuarantine quarantine;

    /**
     * The Steady State First Achieved Time.
     * The time when steady state (no more changes to the process) was first achieved. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "steadyStateFirstAchievedTime", alternate = {"SteadyStateFirstAchievedTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime steadyStateFirstAchievedTime;

    /**
     * The Steady State Last Achieved Time.
     * The time when steady state (no more changes to the process) was last achieved. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "steadyStateLastAchievedTime", alternate = {"SteadyStateLastAchievedTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime steadyStateLastAchievedTime;

    /**
     * The Synchronized Entry Count By Type.
     * Count of synchronized objects, listed by object type.
     */
    @SerializedName(value = "synchronizedEntryCountByType", alternate = {"SynchronizedEntryCountByType"})
    @Expose
	@Nullable
    public java.util.List<StringKeyLongValuePair> synchronizedEntryCountByType;

    /**
     * The Troubleshooting Url.
     * In the event of an error, the URL with the troubleshooting steps for the issue.
     */
    @SerializedName(value = "troubleshootingUrl", alternate = {"TroubleshootingUrl"})
    @Expose
	@Nullable
    public String troubleshootingUrl;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
