// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.SynchronizationMetadataEntry;
import com.microsoft.graph.models.SynchronizationSchema;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Template.
 */
public class SynchronizationTemplate extends Entity implements IJsonBackedObject {


    /**
     * The Application Id.
     * Identifier of the application this template belongs to.
     */
    @SerializedName(value = "applicationId", alternate = {"ApplicationId"})
    @Expose
	@Nullable
    public java.util.UUID applicationId;

    /**
     * The Default.
     * true if this template is recommended to be the default for the application.
     */
    @SerializedName(value = "default", alternate = {"Default"})
    @Expose
	@Nullable
    public Boolean msgraphDefault;

    /**
     * The Description.
     * Description of the template.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Discoverable.
     * true if this template should appear in the collection of templates available for the application instance (service principal).
     */
    @SerializedName(value = "discoverable", alternate = {"Discoverable"})
    @Expose
	@Nullable
    public Boolean discoverable;

    /**
     * The Factory Tag.
     * One of the well-known factory tags supported by the synchronization engine. The factoryTag tells the synchronization engine which implementation to use when processing jobs based on this template.
     */
    @SerializedName(value = "factoryTag", alternate = {"FactoryTag"})
    @Expose
	@Nullable
    public String factoryTag;

    /**
     * The Metadata.
     * Additional extension properties. Unless mentioned explicitly, metadata values should not be changed.
     */
    @SerializedName(value = "metadata", alternate = {"Metadata"})
    @Expose
	@Nullable
    public java.util.List<SynchronizationMetadataEntry> metadata;

    /**
     * The Schema.
     * Default synchronization schema for the jobs based on this template.
     */
    @SerializedName(value = "schema", alternate = {"Schema"})
    @Expose
	@Nullable
    public SynchronizationSchema schema;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
