// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.UserExperienceAnalyticsOperatingSystemRestartCategory;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Device Startup History.
 */
public class UserExperienceAnalyticsDeviceStartupHistory extends Entity implements IJsonBackedObject {


    /**
     * The Core Boot Time In Ms.
     * The device core boot time in milliseconds. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "coreBootTimeInMs", alternate = {"CoreBootTimeInMs"})
    @Expose
	@Nullable
    public Integer coreBootTimeInMs;

    /**
     * The Core Login Time In Ms.
     * The device core login time in milliseconds. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "coreLoginTimeInMs", alternate = {"CoreLoginTimeInMs"})
    @Expose
	@Nullable
    public Integer coreLoginTimeInMs;

    /**
     * The Device Id.
     * The Intune device id of the device. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "deviceId", alternate = {"DeviceId"})
    @Expose
	@Nullable
    public String deviceId;

    /**
     * The Feature Update Boot Time In Ms.
     * The impact of device feature updates on boot time in milliseconds. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "featureUpdateBootTimeInMs", alternate = {"FeatureUpdateBootTimeInMs"})
    @Expose
	@Nullable
    public Integer featureUpdateBootTimeInMs;

    /**
     * The Group Policy Boot Time In Ms.
     * The impact of device group policy client on boot time in milliseconds. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "groupPolicyBootTimeInMs", alternate = {"GroupPolicyBootTimeInMs"})
    @Expose
	@Nullable
    public Integer groupPolicyBootTimeInMs;

    /**
     * The Group Policy Login Time In Ms.
     * The impact of device group policy client on login time in milliseconds. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "groupPolicyLoginTimeInMs", alternate = {"GroupPolicyLoginTimeInMs"})
    @Expose
	@Nullable
    public Integer groupPolicyLoginTimeInMs;

    /**
     * The Is Feature Update.
     * When TRUE, indicates the device boot record is associated with feature updates. When FALSE, indicates the device boot record is not associated with feature updates. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "isFeatureUpdate", alternate = {"IsFeatureUpdate"})
    @Expose
	@Nullable
    public Boolean isFeatureUpdate;

    /**
     * The Is First Login.
     * When TRUE, indicates the device login is the first login after a reboot. When FALSE, indicates the device login is not the first login after a reboot. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "isFirstLogin", alternate = {"IsFirstLogin"})
    @Expose
	@Nullable
    public Boolean isFirstLogin;

    /**
     * The Operating System Version.
     * The user experience analytics device boot record's operating system version. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "operatingSystemVersion", alternate = {"OperatingSystemVersion"})
    @Expose
	@Nullable
    public String operatingSystemVersion;

    /**
     * The Responsive Desktop Time In Ms.
     * The time for desktop to become responsive during login process in milliseconds. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "responsiveDesktopTimeInMs", alternate = {"ResponsiveDesktopTimeInMs"})
    @Expose
	@Nullable
    public Integer responsiveDesktopTimeInMs;

    /**
     * The Restart Category.
     * OS restart category. Possible values are: unknown, restartWithUpdate, restartWithoutUpdate, blueScreen, shutdownWithUpdate, shutdownWithoutUpdate, longPowerButtonPress, bootError, update. Unknown by default. Supports: $select, $OrderBy. Read-only. Possible values are: unknown, restartWithUpdate, restartWithoutUpdate, blueScreen, shutdownWithUpdate, shutdownWithoutUpdate, longPowerButtonPress, bootError, update, unknownFutureValue.
     */
    @SerializedName(value = "restartCategory", alternate = {"RestartCategory"})
    @Expose
	@Nullable
    public UserExperienceAnalyticsOperatingSystemRestartCategory restartCategory;

    /**
     * The Restart Fault Bucket.
     * OS restart fault bucket. The fault bucket is used to find additional information about a system crash. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "restartFaultBucket", alternate = {"RestartFaultBucket"})
    @Expose
	@Nullable
    public String restartFaultBucket;

    /**
     * The Restart Stop Code.
     * OS restart stop code. This shows the bug check code which can be used to look up the blue screen reason. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "restartStopCode", alternate = {"RestartStopCode"})
    @Expose
	@Nullable
    public String restartStopCode;

    /**
     * The Start Time.
     * The device boot start time. The value cannot be modified and is automatically populated when the device performs a reboot. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2022 would look like this: '2022-01-01T00:00:00Z'. Returned by default. Read-only.
     */
    @SerializedName(value = "startTime", alternate = {"StartTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startTime;

    /**
     * The Total Boot Time In Ms.
     * The device total boot time in milliseconds. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "totalBootTimeInMs", alternate = {"TotalBootTimeInMs"})
    @Expose
	@Nullable
    public Integer totalBootTimeInMs;

    /**
     * The Total Login Time In Ms.
     * The device total login time in milliseconds. Supports: $select, $OrderBy. Read-only.
     */
    @SerializedName(value = "totalLoginTimeInMs", alternate = {"TotalLoginTimeInMs"})
    @Expose
	@Nullable
    public Integer totalLoginTimeInMs;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
