// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions F_Dist Parameter Set.
 */
public class WorkbookFunctionsF_DistParameterSet {
    /**
     * The x.
     * 
     */
    @SerializedName(value = "x", alternate = {"X"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement x;

    /**
     * The deg Freedom1.
     * 
     */
    @SerializedName(value = "degFreedom1", alternate = {"DegFreedom1"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement degFreedom1;

    /**
     * The deg Freedom2.
     * 
     */
    @SerializedName(value = "degFreedom2", alternate = {"DegFreedom2"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement degFreedom2;

    /**
     * The cumulative.
     * 
     */
    @SerializedName(value = "cumulative", alternate = {"Cumulative"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement cumulative;


    /**
     * Instiaciates a new WorkbookFunctionsF_DistParameterSet
     */
    public WorkbookFunctionsF_DistParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsF_DistParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsF_DistParameterSet(@Nonnull final WorkbookFunctionsF_DistParameterSetBuilder builder) {
        this.x = builder.x;
        this.degFreedom1 = builder.degFreedom1;
        this.degFreedom2 = builder.degFreedom2;
        this.cumulative = builder.cumulative;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsF_DistParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsF_DistParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsF_DistParameterSet
     */
    public static final class WorkbookFunctionsF_DistParameterSetBuilder {
        /**
         * The x parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement x;
        /**
         * Sets the X
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsF_DistParameterSetBuilder withX(@Nullable final com.google.gson.JsonElement val) {
            this.x = val;
            return this;
        }
        /**
         * The degFreedom1 parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement degFreedom1;
        /**
         * Sets the DegFreedom1
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsF_DistParameterSetBuilder withDegFreedom1(@Nullable final com.google.gson.JsonElement val) {
            this.degFreedom1 = val;
            return this;
        }
        /**
         * The degFreedom2 parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement degFreedom2;
        /**
         * Sets the DegFreedom2
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsF_DistParameterSetBuilder withDegFreedom2(@Nullable final com.google.gson.JsonElement val) {
            this.degFreedom2 = val;
            return this;
        }
        /**
         * The cumulative parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement cumulative;
        /**
         * Sets the Cumulative
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsF_DistParameterSetBuilder withCumulative(@Nullable final com.google.gson.JsonElement val) {
            this.cumulative = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsF_DistParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsF_DistParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsF_DistParameterSet build() {
            return new WorkbookFunctionsF_DistParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.x != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("x", x));
        }
        if(this.degFreedom1 != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("degFreedom1", degFreedom1));
        }
        if(this.degFreedom2 != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("degFreedom2", degFreedom2));
        }
        if(this.cumulative != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("cumulative", cumulative));
        }
        return result;
    }
}
