// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Delete Parameter Set.
 */
public class WorkbookRangeDeleteParameterSet {
    /**
     * The shift.
     * 
     */
    @SerializedName(value = "shift", alternate = {"Shift"})
    @Expose
	@Nullable
    public String shift;


    /**
     * Instiaciates a new WorkbookRangeDeleteParameterSet
     */
    public WorkbookRangeDeleteParameterSet() {}
    /**
     * Instiaciates a new WorkbookRangeDeleteParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookRangeDeleteParameterSet(@Nonnull final WorkbookRangeDeleteParameterSetBuilder builder) {
        this.shift = builder.shift;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookRangeDeleteParameterSetBuilder newBuilder() {
        return new WorkbookRangeDeleteParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookRangeDeleteParameterSet
     */
    public static final class WorkbookRangeDeleteParameterSetBuilder {
        /**
         * The shift parameter value
         */
        @Nullable
        protected String shift;
        /**
         * Sets the Shift
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookRangeDeleteParameterSetBuilder withShift(@Nullable final String val) {
            this.shift = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookRangeDeleteParameterSetBuilder
         */
        @Nullable
        protected WorkbookRangeDeleteParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookRangeDeleteParameterSet build() {
            return new WorkbookRangeDeleteParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.shift != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("shift", shift));
        }
        return result;
    }
}
