// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServicePrincipal;
import com.microsoft.graph.models.AppManagementPolicy;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ExtensionProperty;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AppManagementPolicyCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.AppManagementPolicyCollectionWithReferencesPage;
import com.microsoft.graph.requests.AppManagementPolicyCollectionResponse;
import com.microsoft.graph.models.AppManagementPolicy;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the App Management Policy Collection With References Page.
 */
public class AppManagementPolicyCollectionWithReferencesPage extends BaseCollectionPage<AppManagementPolicy, AppManagementPolicyCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for AppManagementPolicy
     *
     * @param response the serialized AppManagementPolicyCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public AppManagementPolicyCollectionWithReferencesPage(@Nonnull final AppManagementPolicyCollectionResponse response, @Nullable final AppManagementPolicyCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for AppManagementPolicy
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public AppManagementPolicyCollectionWithReferencesPage(@Nonnull final java.util.List<AppManagementPolicy> pageContents, @Nullable final AppManagementPolicyCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
