// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.ApplicationTemplateInstantiateRequest;
import com.microsoft.graph.models.ApplicationTemplate;
import com.microsoft.graph.models.ApplicationServicePrincipal;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.ApplicationTemplateInstantiateParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Application Template Instantiate Request Builder.
 */
public class ApplicationTemplateInstantiateRequestBuilder extends BaseActionRequestBuilder<ApplicationServicePrincipal> {

    /**
     * The request builder for this ApplicationTemplateInstantiate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ApplicationTemplateInstantiateRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private ApplicationTemplateInstantiateParameterSet body;
    /**
     * The request builder for this ApplicationTemplateInstantiate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ApplicationTemplateInstantiateRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ApplicationTemplateInstantiateParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the ApplicationTemplateInstantiateRequest
     *
     * @param requestOptions the options for the request
     * @return the ApplicationTemplateInstantiateRequest instance
     */
    @Nonnull
    public ApplicationTemplateInstantiateRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the ApplicationTemplateInstantiateRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ApplicationTemplateInstantiateRequest instance
     */
    @Nonnull
    public ApplicationTemplateInstantiateRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ApplicationTemplateInstantiateRequest request = new ApplicationTemplateInstantiateRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
