// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ApprovalStage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Approval Stage Request.
 */
public class ApprovalStageRequest extends BaseRequest<ApprovalStage> {
	
    /**
     * The request for the ApprovalStage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ApprovalStageRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApprovalStage.class);
    }

    /**
     * Gets the ApprovalStage from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ApprovalStage> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ApprovalStage from the service
     *
     * @return the ApprovalStage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ApprovalStage get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ApprovalStage> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ApprovalStage delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ApprovalStage with a source
     *
     * @param sourceApprovalStage the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ApprovalStage> patchAsync(@Nonnull final ApprovalStage sourceApprovalStage) {
        return sendAsync(HttpMethod.PATCH, sourceApprovalStage);
    }

    /**
     * Patches this ApprovalStage with a source
     *
     * @param sourceApprovalStage the source object with updates
     * @return the updated ApprovalStage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ApprovalStage patch(@Nonnull final ApprovalStage sourceApprovalStage) throws ClientException {
        return send(HttpMethod.PATCH, sourceApprovalStage);
    }

    /**
     * Creates a ApprovalStage with a new object
     *
     * @param newApprovalStage the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ApprovalStage> postAsync(@Nonnull final ApprovalStage newApprovalStage) {
        return sendAsync(HttpMethod.POST, newApprovalStage);
    }

    /**
     * Creates a ApprovalStage with a new object
     *
     * @param newApprovalStage the new object to create
     * @return the created ApprovalStage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ApprovalStage post(@Nonnull final ApprovalStage newApprovalStage) throws ClientException {
        return send(HttpMethod.POST, newApprovalStage);
    }

    /**
     * Creates a ApprovalStage with a new object
     *
     * @param newApprovalStage the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ApprovalStage> putAsync(@Nonnull final ApprovalStage newApprovalStage) {
        return sendAsync(HttpMethod.PUT, newApprovalStage);
    }

    /**
     * Creates a ApprovalStage with a new object
     *
     * @param newApprovalStage the object to create/update
     * @return the created ApprovalStage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ApprovalStage put(@Nonnull final ApprovalStage newApprovalStage) throws ClientException {
        return send(HttpMethod.PUT, newApprovalStage);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ApprovalStageRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ApprovalStageRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

