// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationMethodTarget;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Method Target Request.
 */
public class AuthenticationMethodTargetRequest extends BaseRequest<AuthenticationMethodTarget> {
	
    /**
     * The request for the AuthenticationMethodTarget
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public AuthenticationMethodTargetRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends AuthenticationMethodTarget> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the AuthenticationMethodTarget
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationMethodTargetRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethodTarget.class);
    }

    /**
     * Gets the AuthenticationMethodTarget from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodTarget> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AuthenticationMethodTarget from the service
     *
     * @return the AuthenticationMethodTarget from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodTarget get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodTarget> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AuthenticationMethodTarget delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationMethodTarget with a source
     *
     * @param sourceAuthenticationMethodTarget the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodTarget> patchAsync(@Nonnull final AuthenticationMethodTarget sourceAuthenticationMethodTarget) {
        return sendAsync(HttpMethod.PATCH, sourceAuthenticationMethodTarget);
    }

    /**
     * Patches this AuthenticationMethodTarget with a source
     *
     * @param sourceAuthenticationMethodTarget the source object with updates
     * @return the updated AuthenticationMethodTarget
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodTarget patch(@Nonnull final AuthenticationMethodTarget sourceAuthenticationMethodTarget) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationMethodTarget);
    }

    /**
     * Creates a AuthenticationMethodTarget with a new object
     *
     * @param newAuthenticationMethodTarget the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodTarget> postAsync(@Nonnull final AuthenticationMethodTarget newAuthenticationMethodTarget) {
        return sendAsync(HttpMethod.POST, newAuthenticationMethodTarget);
    }

    /**
     * Creates a AuthenticationMethodTarget with a new object
     *
     * @param newAuthenticationMethodTarget the new object to create
     * @return the created AuthenticationMethodTarget
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodTarget post(@Nonnull final AuthenticationMethodTarget newAuthenticationMethodTarget) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationMethodTarget);
    }

    /**
     * Creates a AuthenticationMethodTarget with a new object
     *
     * @param newAuthenticationMethodTarget the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodTarget> putAsync(@Nonnull final AuthenticationMethodTarget newAuthenticationMethodTarget) {
        return sendAsync(HttpMethod.PUT, newAuthenticationMethodTarget);
    }

    /**
     * Creates a AuthenticationMethodTarget with a new object
     *
     * @param newAuthenticationMethodTarget the object to create/update
     * @return the created AuthenticationMethodTarget
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodTarget put(@Nonnull final AuthenticationMethodTarget newAuthenticationMethodTarget) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationMethodTarget);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationMethodTargetRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationMethodTargetRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

