// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.B2xIdentityUserFlow;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the B2x Identity User Flow Request.
 */
public class B2xIdentityUserFlowRequest extends BaseRequest<B2xIdentityUserFlow> {
	
    /**
     * The request for the B2xIdentityUserFlow
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public B2xIdentityUserFlowRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, B2xIdentityUserFlow.class);
    }

    /**
     * Gets the B2xIdentityUserFlow from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<B2xIdentityUserFlow> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the B2xIdentityUserFlow from the service
     *
     * @return the B2xIdentityUserFlow from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public B2xIdentityUserFlow get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<B2xIdentityUserFlow> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public B2xIdentityUserFlow delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this B2xIdentityUserFlow with a source
     *
     * @param sourceB2xIdentityUserFlow the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<B2xIdentityUserFlow> patchAsync(@Nonnull final B2xIdentityUserFlow sourceB2xIdentityUserFlow) {
        return sendAsync(HttpMethod.PATCH, sourceB2xIdentityUserFlow);
    }

    /**
     * Patches this B2xIdentityUserFlow with a source
     *
     * @param sourceB2xIdentityUserFlow the source object with updates
     * @return the updated B2xIdentityUserFlow
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public B2xIdentityUserFlow patch(@Nonnull final B2xIdentityUserFlow sourceB2xIdentityUserFlow) throws ClientException {
        return send(HttpMethod.PATCH, sourceB2xIdentityUserFlow);
    }

    /**
     * Creates a B2xIdentityUserFlow with a new object
     *
     * @param newB2xIdentityUserFlow the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<B2xIdentityUserFlow> postAsync(@Nonnull final B2xIdentityUserFlow newB2xIdentityUserFlow) {
        return sendAsync(HttpMethod.POST, newB2xIdentityUserFlow);
    }

    /**
     * Creates a B2xIdentityUserFlow with a new object
     *
     * @param newB2xIdentityUserFlow the new object to create
     * @return the created B2xIdentityUserFlow
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public B2xIdentityUserFlow post(@Nonnull final B2xIdentityUserFlow newB2xIdentityUserFlow) throws ClientException {
        return send(HttpMethod.POST, newB2xIdentityUserFlow);
    }

    /**
     * Creates a B2xIdentityUserFlow with a new object
     *
     * @param newB2xIdentityUserFlow the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<B2xIdentityUserFlow> putAsync(@Nonnull final B2xIdentityUserFlow newB2xIdentityUserFlow) {
        return sendAsync(HttpMethod.PUT, newB2xIdentityUserFlow);
    }

    /**
     * Creates a B2xIdentityUserFlow with a new object
     *
     * @param newB2xIdentityUserFlow the object to create/update
     * @return the created B2xIdentityUserFlow
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public B2xIdentityUserFlow put(@Nonnull final B2xIdentityUserFlow newB2xIdentityUserFlow) throws ClientException {
        return send(HttpMethod.PUT, newB2xIdentityUserFlow);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public B2xIdentityUserFlowRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public B2xIdentityUserFlowRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

