// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.CallCancelMediaProcessingRequest;
import com.microsoft.graph.models.Call;
import com.microsoft.graph.models.CancelMediaProcessingOperation;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.CallCancelMediaProcessingParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Cancel Media Processing Request Builder.
 */
public class CallCancelMediaProcessingRequestBuilder extends BaseActionRequestBuilder<CancelMediaProcessingOperation> {

    /**
     * The request builder for this CallCancelMediaProcessing
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CallCancelMediaProcessingRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private CallCancelMediaProcessingParameterSet body;
    /**
     * The request builder for this CallCancelMediaProcessing
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public CallCancelMediaProcessingRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final CallCancelMediaProcessingParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the CallCancelMediaProcessingRequest
     *
     * @param requestOptions the options for the request
     * @return the CallCancelMediaProcessingRequest instance
     */
    @Nonnull
    public CallCancelMediaProcessingRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the CallCancelMediaProcessingRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the CallCancelMediaProcessingRequest instance
     */
    @Nonnull
    public CallCancelMediaProcessingRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final CallCancelMediaProcessingRequest request = new CallCancelMediaProcessingRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
