// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Team;
import com.microsoft.graph.models.Channel;
import com.microsoft.graph.models.ProvisionChannelEmailResult;
import com.microsoft.graph.models.ChatMessage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ChannelCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ChannelCollectionWithReferencesPage;
import com.microsoft.graph.requests.ChannelCollectionResponse;
import com.microsoft.graph.models.Channel;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Channel Collection With References Page.
 */
public class ChannelCollectionWithReferencesPage extends BaseCollectionPage<Channel, ChannelCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for Channel
     *
     * @param response the serialized ChannelCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public ChannelCollectionWithReferencesPage(@Nonnull final ChannelCollectionResponse response, @Nullable final ChannelCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for Channel
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public ChannelCollectionWithReferencesPage(@Nonnull final java.util.List<Channel> pageContents, @Nullable final ChannelCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
