// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ChatMessageInfo;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Message Info Request.
 */
public class ChatMessageInfoRequest extends BaseRequest<ChatMessageInfo> {
	
    /**
     * The request for the ChatMessageInfo
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ChatMessageInfoRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChatMessageInfo.class);
    }

    /**
     * Gets the ChatMessageInfo from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessageInfo> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ChatMessageInfo from the service
     *
     * @return the ChatMessageInfo from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChatMessageInfo get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessageInfo> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ChatMessageInfo delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ChatMessageInfo with a source
     *
     * @param sourceChatMessageInfo the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessageInfo> patchAsync(@Nonnull final ChatMessageInfo sourceChatMessageInfo) {
        return sendAsync(HttpMethod.PATCH, sourceChatMessageInfo);
    }

    /**
     * Patches this ChatMessageInfo with a source
     *
     * @param sourceChatMessageInfo the source object with updates
     * @return the updated ChatMessageInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChatMessageInfo patch(@Nonnull final ChatMessageInfo sourceChatMessageInfo) throws ClientException {
        return send(HttpMethod.PATCH, sourceChatMessageInfo);
    }

    /**
     * Creates a ChatMessageInfo with a new object
     *
     * @param newChatMessageInfo the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessageInfo> postAsync(@Nonnull final ChatMessageInfo newChatMessageInfo) {
        return sendAsync(HttpMethod.POST, newChatMessageInfo);
    }

    /**
     * Creates a ChatMessageInfo with a new object
     *
     * @param newChatMessageInfo the new object to create
     * @return the created ChatMessageInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChatMessageInfo post(@Nonnull final ChatMessageInfo newChatMessageInfo) throws ClientException {
        return send(HttpMethod.POST, newChatMessageInfo);
    }

    /**
     * Creates a ChatMessageInfo with a new object
     *
     * @param newChatMessageInfo the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChatMessageInfo> putAsync(@Nonnull final ChatMessageInfo newChatMessageInfo) {
        return sendAsync(HttpMethod.PUT, newChatMessageInfo);
    }

    /**
     * Creates a ChatMessageInfo with a new object
     *
     * @param newChatMessageInfo the object to create/update
     * @return the created ChatMessageInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChatMessageInfo put(@Nonnull final ChatMessageInfo newChatMessageInfo) throws ClientException {
        return send(HttpMethod.PUT, newChatMessageInfo);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ChatMessageInfoRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ChatMessageInfoRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

