// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ColumnLink;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Column Link Request.
 */
public class ColumnLinkRequest extends BaseRequest<ColumnLink> {
	
    /**
     * The request for the ColumnLink
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ColumnLinkRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ColumnLink.class);
    }

    /**
     * Gets the ColumnLink from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnLink> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ColumnLink from the service
     *
     * @return the ColumnLink from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ColumnLink get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnLink> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ColumnLink delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ColumnLink with a source
     *
     * @param sourceColumnLink the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnLink> patchAsync(@Nonnull final ColumnLink sourceColumnLink) {
        return sendAsync(HttpMethod.PATCH, sourceColumnLink);
    }

    /**
     * Patches this ColumnLink with a source
     *
     * @param sourceColumnLink the source object with updates
     * @return the updated ColumnLink
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ColumnLink patch(@Nonnull final ColumnLink sourceColumnLink) throws ClientException {
        return send(HttpMethod.PATCH, sourceColumnLink);
    }

    /**
     * Creates a ColumnLink with a new object
     *
     * @param newColumnLink the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnLink> postAsync(@Nonnull final ColumnLink newColumnLink) {
        return sendAsync(HttpMethod.POST, newColumnLink);
    }

    /**
     * Creates a ColumnLink with a new object
     *
     * @param newColumnLink the new object to create
     * @return the created ColumnLink
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ColumnLink post(@Nonnull final ColumnLink newColumnLink) throws ClientException {
        return send(HttpMethod.POST, newColumnLink);
    }

    /**
     * Creates a ColumnLink with a new object
     *
     * @param newColumnLink the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ColumnLink> putAsync(@Nonnull final ColumnLink newColumnLink) {
        return sendAsync(HttpMethod.PUT, newColumnLink);
    }

    /**
     * Creates a ColumnLink with a new object
     *
     * @param newColumnLink the object to create/update
     * @return the created ColumnLink
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ColumnLink put(@Nonnull final ColumnLink newColumnLink) throws ClientException {
        return send(HttpMethod.PUT, newColumnLink);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ColumnLinkRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ColumnLinkRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

