// Template Source: BaseEntityCollectionReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationStrengthUsage;
import com.microsoft.graph.models.ConditionalAccessPolicy;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ConditionalAccessPolicyWithReferenceRequest;
import com.microsoft.graph.requests.ConditionalAccessPolicyReferenceRequestBuilder;
import com.microsoft.graph.requests.ConditionalAccessPolicyWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ConditionalAccessPolicyCollectionWithReferencesRequest;
import com.microsoft.graph.requests.ConditionalAccessPolicyCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.models.ConditionalAccessPolicy;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.http.ReferenceRequestBody;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Policy Collection Reference Request.
 */
public class ConditionalAccessPolicyCollectionReferenceRequest extends BaseCollectionWithReferencesRequest<ConditionalAccessPolicy, ConditionalAccessPolicyWithReferenceRequest, ConditionalAccessPolicyReferenceRequestBuilder, ConditionalAccessPolicyWithReferenceRequestBuilder, ConditionalAccessPolicyCollectionResponse, ConditionalAccessPolicyCollectionWithReferencesPage, ConditionalAccessPolicyCollectionWithReferencesRequest> {

    /**
     * The request builder for this collection of ConditionalAccessPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ConditionalAccessPolicyCollectionReferenceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConditionalAccessPolicyCollectionResponse.class, ConditionalAccessPolicyCollectionWithReferencesPage.class, ConditionalAccessPolicyCollectionWithReferencesRequestBuilder.class);
    }

    /**
     * Creates a new ConditionalAccessPolicy
     * @param newConditionalAccessPolicy the ConditionalAccessPolicy to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConditionalAccessPolicy> postAsync(@Nonnull final ConditionalAccessPolicy newConditionalAccessPolicy) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/policies/none/" + newConditionalAccessPolicy.id);
        return new ConditionalAccessPolicyWithReferenceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newConditionalAccessPolicy, body);
    }

    /**
     * Creates a new ConditionalAccessPolicy
     * @param newConditionalAccessPolicy the ConditionalAccessPolicy to create
     * @return the newly created object
     */
    @Nonnull
    public ConditionalAccessPolicy post(@Nonnull final ConditionalAccessPolicy newConditionalAccessPolicy) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        final ReferenceRequestBody body = new ReferenceRequestBody(getBaseRequest().getClient().getServiceRoot() + "/policies/none/" + newConditionalAccessPolicy.id);
        return new ConditionalAccessPolicyWithReferenceRequestBuilder(requestUrl,getBaseRequest().getClient(), /* Options */ null)
                .buildRequest(getBaseRequest().getHeaders())
                .post(newConditionalAccessPolicy, body);
    }
    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public ConditionalAccessPolicyCollectionReferenceRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public ConditionalAccessPolicyCollectionReferenceRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the sort clause
     * @return the updated request
     */
    @Nonnull
    public ConditionalAccessPolicyCollectionReferenceRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public ConditionalAccessPolicyCollectionReferenceRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public ConditionalAccessPolicyCollectionReferenceRequest top(final int value) {
        addTopOption(value);
        return this;
    }
    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public ConditionalAccessPolicyCollectionReferenceRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public ConditionalAccessPolicyCollectionReferenceRequest count() {
        addCountOption(true);
        return this;
    }
}
