// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DelegatedPermissionClassification;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Delegated Permission Classification Request.
 */
public class DelegatedPermissionClassificationRequest extends BaseRequest<DelegatedPermissionClassification> {
	
    /**
     * The request for the DelegatedPermissionClassification
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DelegatedPermissionClassificationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DelegatedPermissionClassification.class);
    }

    /**
     * Gets the DelegatedPermissionClassification from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedPermissionClassification> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DelegatedPermissionClassification from the service
     *
     * @return the DelegatedPermissionClassification from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedPermissionClassification get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedPermissionClassification> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DelegatedPermissionClassification delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DelegatedPermissionClassification with a source
     *
     * @param sourceDelegatedPermissionClassification the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedPermissionClassification> patchAsync(@Nonnull final DelegatedPermissionClassification sourceDelegatedPermissionClassification) {
        return sendAsync(HttpMethod.PATCH, sourceDelegatedPermissionClassification);
    }

    /**
     * Patches this DelegatedPermissionClassification with a source
     *
     * @param sourceDelegatedPermissionClassification the source object with updates
     * @return the updated DelegatedPermissionClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedPermissionClassification patch(@Nonnull final DelegatedPermissionClassification sourceDelegatedPermissionClassification) throws ClientException {
        return send(HttpMethod.PATCH, sourceDelegatedPermissionClassification);
    }

    /**
     * Creates a DelegatedPermissionClassification with a new object
     *
     * @param newDelegatedPermissionClassification the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedPermissionClassification> postAsync(@Nonnull final DelegatedPermissionClassification newDelegatedPermissionClassification) {
        return sendAsync(HttpMethod.POST, newDelegatedPermissionClassification);
    }

    /**
     * Creates a DelegatedPermissionClassification with a new object
     *
     * @param newDelegatedPermissionClassification the new object to create
     * @return the created DelegatedPermissionClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedPermissionClassification post(@Nonnull final DelegatedPermissionClassification newDelegatedPermissionClassification) throws ClientException {
        return send(HttpMethod.POST, newDelegatedPermissionClassification);
    }

    /**
     * Creates a DelegatedPermissionClassification with a new object
     *
     * @param newDelegatedPermissionClassification the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedPermissionClassification> putAsync(@Nonnull final DelegatedPermissionClassification newDelegatedPermissionClassification) {
        return sendAsync(HttpMethod.PUT, newDelegatedPermissionClassification);
    }

    /**
     * Creates a DelegatedPermissionClassification with a new object
     *
     * @param newDelegatedPermissionClassification the object to create/update
     * @return the created DelegatedPermissionClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedPermissionClassification put(@Nonnull final DelegatedPermissionClassification newDelegatedPermissionClassification) throws ClientException {
        return send(HttpMethod.PUT, newDelegatedPermissionClassification);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DelegatedPermissionClassificationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DelegatedPermissionClassificationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

