// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationSchool;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.EducationSchoolDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.EducationSchoolDeltaCollectionRequest;
import com.microsoft.graph.requests.EducationSchoolDeltaCollectionResponse;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education School Delta Collection Request Builder.
 */
public class EducationSchoolDeltaCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<EducationSchool, EducationSchoolDeltaCollectionRequestBuilder, EducationSchoolDeltaCollectionResponse, EducationSchoolDeltaCollectionPage, EducationSchoolDeltaCollectionRequest> {

    /**
     * The request builder for this collection of EducationSchool
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationSchoolDeltaCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationSchoolDeltaCollectionRequestBuilder.class, EducationSchoolDeltaCollectionRequest.class);
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the EducationSchoolDeltaCollectionRequest instance
     */
    @Override
    @Nonnull
    public EducationSchoolDeltaCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EducationSchoolDeltaCollectionRequest request = super.buildRequest(requestOptions);
        return request;
    }
}
