// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EmployeeExperience;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Employee Experience Request.
 */
public class EmployeeExperienceRequest extends BaseRequest<EmployeeExperience> {
	
    /**
     * The request for the EmployeeExperience
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EmployeeExperienceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EmployeeExperience.class);
    }

    /**
     * Gets the EmployeeExperience from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperience> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EmployeeExperience from the service
     *
     * @return the EmployeeExperience from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmployeeExperience get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperience> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EmployeeExperience delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EmployeeExperience with a source
     *
     * @param sourceEmployeeExperience the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperience> patchAsync(@Nonnull final EmployeeExperience sourceEmployeeExperience) {
        return sendAsync(HttpMethod.PATCH, sourceEmployeeExperience);
    }

    /**
     * Patches this EmployeeExperience with a source
     *
     * @param sourceEmployeeExperience the source object with updates
     * @return the updated EmployeeExperience
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmployeeExperience patch(@Nonnull final EmployeeExperience sourceEmployeeExperience) throws ClientException {
        return send(HttpMethod.PATCH, sourceEmployeeExperience);
    }

    /**
     * Creates a EmployeeExperience with a new object
     *
     * @param newEmployeeExperience the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperience> postAsync(@Nonnull final EmployeeExperience newEmployeeExperience) {
        return sendAsync(HttpMethod.POST, newEmployeeExperience);
    }

    /**
     * Creates a EmployeeExperience with a new object
     *
     * @param newEmployeeExperience the new object to create
     * @return the created EmployeeExperience
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmployeeExperience post(@Nonnull final EmployeeExperience newEmployeeExperience) throws ClientException {
        return send(HttpMethod.POST, newEmployeeExperience);
    }

    /**
     * Creates a EmployeeExperience with a new object
     *
     * @param newEmployeeExperience the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperience> putAsync(@Nonnull final EmployeeExperience newEmployeeExperience) {
        return sendAsync(HttpMethod.PUT, newEmployeeExperience);
    }

    /**
     * Creates a EmployeeExperience with a new object
     *
     * @param newEmployeeExperience the object to create/update
     * @return the created EmployeeExperience
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmployeeExperience put(@Nonnull final EmployeeExperience newEmployeeExperience) throws ClientException {
        return send(HttpMethod.PUT, newEmployeeExperience);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EmployeeExperienceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EmployeeExperienceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

