// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EmployeeExperienceUser;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Employee Experience User Request.
 */
public class EmployeeExperienceUserRequest extends BaseRequest<EmployeeExperienceUser> {
	
    /**
     * The request for the EmployeeExperienceUser
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EmployeeExperienceUserRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EmployeeExperienceUser.class);
    }

    /**
     * Gets the EmployeeExperienceUser from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperienceUser> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EmployeeExperienceUser from the service
     *
     * @return the EmployeeExperienceUser from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmployeeExperienceUser get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperienceUser> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EmployeeExperienceUser delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EmployeeExperienceUser with a source
     *
     * @param sourceEmployeeExperienceUser the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperienceUser> patchAsync(@Nonnull final EmployeeExperienceUser sourceEmployeeExperienceUser) {
        return sendAsync(HttpMethod.PATCH, sourceEmployeeExperienceUser);
    }

    /**
     * Patches this EmployeeExperienceUser with a source
     *
     * @param sourceEmployeeExperienceUser the source object with updates
     * @return the updated EmployeeExperienceUser
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmployeeExperienceUser patch(@Nonnull final EmployeeExperienceUser sourceEmployeeExperienceUser) throws ClientException {
        return send(HttpMethod.PATCH, sourceEmployeeExperienceUser);
    }

    /**
     * Creates a EmployeeExperienceUser with a new object
     *
     * @param newEmployeeExperienceUser the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperienceUser> postAsync(@Nonnull final EmployeeExperienceUser newEmployeeExperienceUser) {
        return sendAsync(HttpMethod.POST, newEmployeeExperienceUser);
    }

    /**
     * Creates a EmployeeExperienceUser with a new object
     *
     * @param newEmployeeExperienceUser the new object to create
     * @return the created EmployeeExperienceUser
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmployeeExperienceUser post(@Nonnull final EmployeeExperienceUser newEmployeeExperienceUser) throws ClientException {
        return send(HttpMethod.POST, newEmployeeExperienceUser);
    }

    /**
     * Creates a EmployeeExperienceUser with a new object
     *
     * @param newEmployeeExperienceUser the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EmployeeExperienceUser> putAsync(@Nonnull final EmployeeExperienceUser newEmployeeExperienceUser) {
        return sendAsync(HttpMethod.PUT, newEmployeeExperienceUser);
    }

    /**
     * Creates a EmployeeExperienceUser with a new object
     *
     * @param newEmployeeExperienceUser the object to create/update
     * @return the created EmployeeExperienceUser
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EmployeeExperienceUser put(@Nonnull final EmployeeExperienceUser newEmployeeExperienceUser) throws ClientException {
        return send(HttpMethod.PUT, newEmployeeExperienceUser);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EmployeeExperienceUserRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EmployeeExperienceUserRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

