// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Extension;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Extension Request.
 */
public class ExtensionRequest extends BaseRequest<Extension> {
	
    /**
     * The request for the Extension
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ExtensionRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends Extension> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the Extension
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ExtensionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Extension.class);
    }

    /**
     * Gets the Extension from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Extension> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Extension from the service
     *
     * @return the Extension from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Extension get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Extension> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Extension delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Extension with a source
     *
     * @param sourceExtension the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Extension> patchAsync(@Nonnull final Extension sourceExtension) {
        return sendAsync(HttpMethod.PATCH, sourceExtension);
    }

    /**
     * Patches this Extension with a source
     *
     * @param sourceExtension the source object with updates
     * @return the updated Extension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Extension patch(@Nonnull final Extension sourceExtension) throws ClientException {
        return send(HttpMethod.PATCH, sourceExtension);
    }

    /**
     * Creates a Extension with a new object
     *
     * @param newExtension the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Extension> postAsync(@Nonnull final Extension newExtension) {
        return sendAsync(HttpMethod.POST, newExtension);
    }

    /**
     * Creates a Extension with a new object
     *
     * @param newExtension the new object to create
     * @return the created Extension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Extension post(@Nonnull final Extension newExtension) throws ClientException {
        return send(HttpMethod.POST, newExtension);
    }

    /**
     * Creates a Extension with a new object
     *
     * @param newExtension the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Extension> putAsync(@Nonnull final Extension newExtension) {
        return sendAsync(HttpMethod.PUT, newExtension);
    }

    /**
     * Creates a Extension with a new object
     *
     * @param newExtension the object to create/update
     * @return the created Extension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Extension put(@Nonnull final Extension newExtension) throws ClientException {
        return send(HttpMethod.PUT, newExtension);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ExtensionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ExtensionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

