// Template Source: BaseClient.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;

import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.core.BaseClient;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.ISerializer;
import okhttp3.OkHttpClient;
import okhttp3.Request;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Graph Service Client.
 * @param <nativeRequestType> type of a request for the native http client
 */
public class GraphServiceClient<nativeRequestType> extends BaseClient<nativeRequestType> implements IBaseClient<nativeRequestType> {
    /**
     * Restricted constructor
     */
    protected GraphServiceClient() {
        setServiceRoot("https://graph.microsoft.com/v1.0");
    }
    /**
     * Gets the service SDK version if the service SDK is in use, null otherwise
     * @return the service SDK version if the service SDK is in use, null otherwise
     */
    @Override
    @Nullable
    public String getServiceSDKVersion() {
        return com.microsoft.graph.info.Constants.VERSION_NAME;
    }
    /**
     * Gets the builder to start configuring the client
     *
     * @return builder to start configuring the client
     */
    @Nonnull
    public static Builder<OkHttpClient, Request> builder() {
        return builder(OkHttpClient.class, Request.class);
    }

    /**
     * Gets the builder to start configuring the client
     *
     * @param <nativeClient> the type of the native http client
     * @param <nativeRequest> the type of the native http request
     * @param nativeClientClass the class of the native http client
     * @param nativeRequestClass the class of the native http request
     * @return builder to start configuring the client
     */
    @Nonnull
    public static <nativeClient, nativeRequest> Builder<nativeClient, nativeRequest> builder(@Nonnull final Class<nativeClient> nativeClientClass, @Nonnull final Class<nativeRequest> nativeRequestClass) {
        return new Builder<>();
    }
    /**
     * Builder to help configure the Graph service client
     * @param <nativeRequestType> type of a request for the native http client
     */
    public static class Builder<httpClientType, nativeRequestType> extends BaseClient.Builder<httpClientType, nativeRequestType> {
        /**
         * Sets the serializer.
         *
         * @param serializer
         *            the serializer
         * @return the instance of this builder
         */
        @Nonnull
        @Override
        public Builder<httpClientType, nativeRequestType> serializer(@Nonnull final ISerializer serializer) {
            super.serializer(serializer);
            return this;
        }

        /**
         * Sets the httpProvider
         *
         * @param httpProvider
         *            the httpProvider
         * @return the instance of this builder
         */
        @Nonnull
        @Override
        public Builder<httpClientType, nativeRequestType> httpProvider(@Nonnull final IHttpProvider<nativeRequestType> httpProvider) {
            super.httpProvider(httpProvider);
            return this;
        }

        /**
         * Sets the logger
         *
         * @param logger
         *            the logger
         * @return the instance of this builder
         */
        @Nonnull
        @Override
        public Builder<httpClientType, nativeRequestType> logger(@Nonnull final ILogger logger) {
            super.logger(logger);
            return this;
        }

        /**
         * Sets the http client
         *
         * @param client the http client
         *
         * @return the instance of this builder
         */
        @Nonnull
        @Override
        public Builder<httpClientType, nativeRequestType> httpClient(@Nonnull final httpClientType client) {
            super.httpClient(client);
            return this;
        }

        /**
         * Sets the authentication provider
         *
         * @param auth the authentication provider
         * @return the instance of this builder
         */
        @Nonnull
        @Override
        public Builder<httpClientType, nativeRequestType> authenticationProvider(@Nonnull final IAuthenticationProvider auth) {
            super.authenticationProvider(auth);
            return this;
        }

        /**
         * Builds and returns the Graph service client.
         *
         * @return the Graph service client object
         * @throws ClientException
         *             if there was an exception creating the client
         */
        @Nonnull
        @Override
        public GraphServiceClient<nativeRequestType> buildClient() throws ClientException {
            return buildClient(new GraphServiceClient<>());
        }
    }

    /**
     * Gets the collection of Invitations objects
     *
     * @return the request builder for the collection of Invitations objects
     */
    @Nonnull
    public com.microsoft.graph.requests.InvitationCollectionRequestBuilder invitations() {
        return new com.microsoft.graph.requests.InvitationCollectionRequestBuilder(getServiceRoot() + "/invitations", this, null);
    }

    /**
     * Gets a single Invitations
     *
     * @param id the id of the Invitations to retrieve
     * @return the request builder for the Invitations object
     */
    @Nonnull
    public com.microsoft.graph.requests.InvitationRequestBuilder invitations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.InvitationRequestBuilder(getServiceRoot() + "/invitations/" + id, this, null);
    }

    /**
     * Gets the collection of Users objects
     *
     * @return the request builder for the collection of Users objects
     */
    @Nonnull
    public com.microsoft.graph.requests.UserCollectionRequestBuilder users() {
        return new com.microsoft.graph.requests.UserCollectionRequestBuilder(getServiceRoot() + "/users", this, null);
    }

    /**
     * Gets a single Users
     *
     * @param id the id of the Users to retrieve
     * @return the request builder for the Users object
     */
    @Nonnull
    public com.microsoft.graph.requests.UserRequestBuilder users(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UserRequestBuilder(getServiceRoot() + "/users/" + id, this, null);
    }

    /**
     * Gets the collection of ApplicationTemplates objects
     *
     * @return the request builder for the collection of ApplicationTemplates objects
     */
    @Nonnull
    public com.microsoft.graph.requests.ApplicationTemplateCollectionRequestBuilder applicationTemplates() {
        return new com.microsoft.graph.requests.ApplicationTemplateCollectionRequestBuilder(getServiceRoot() + "/applicationTemplates", this, null);
    }

    /**
     * Gets a single ApplicationTemplates
     *
     * @param id the id of the ApplicationTemplates to retrieve
     * @return the request builder for the ApplicationTemplates object
     */
    @Nonnull
    public com.microsoft.graph.requests.ApplicationTemplateRequestBuilder applicationTemplates(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ApplicationTemplateRequestBuilder(getServiceRoot() + "/applicationTemplates/" + id, this, null);
    }

    /**
     * Gets the collection of AuthenticationMethodConfigurations objects
     *
     * @return the request builder for the collection of AuthenticationMethodConfigurations objects
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationMethodConfigurationCollectionRequestBuilder authenticationMethodConfigurations() {
        return new com.microsoft.graph.requests.AuthenticationMethodConfigurationCollectionRequestBuilder(getServiceRoot() + "/authenticationMethodConfigurations", this, null);
    }

    /**
     * Gets a single AuthenticationMethodConfigurations
     *
     * @param id the id of the AuthenticationMethodConfigurations to retrieve
     * @return the request builder for the AuthenticationMethodConfigurations object
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationMethodConfigurationRequestBuilder authenticationMethodConfigurations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AuthenticationMethodConfigurationRequestBuilder(getServiceRoot() + "/authenticationMethodConfigurations/" + id, this, null);
    }

    /**
     * Gets the collection of IdentityProviders objects
     *
     * @return the request builder for the collection of IdentityProviders objects
     * @deprecated The identityProvider API is deprecated and will stop returning data on March 2023. Please use the new identityProviderBase API.
     */
    @Deprecated
    @Nonnull
    public com.microsoft.graph.requests.IdentityProviderCollectionRequestBuilder identityProviders() {
        return new com.microsoft.graph.requests.IdentityProviderCollectionRequestBuilder(getServiceRoot() + "/identityProviders", this, null);
    }

    /**
     * Gets a single IdentityProviders
     *
     * @param id the id of the IdentityProviders to retrieve
     * @return the request builder for the IdentityProviders object
     * @deprecated The identityProvider API is deprecated and will stop returning data on March 2023. Please use the new identityProviderBase API.
     */
    @Deprecated
    @Nonnull
    public com.microsoft.graph.requests.IdentityProviderRequestBuilder identityProviders(@Nonnull final String id) {
        return new com.microsoft.graph.requests.IdentityProviderRequestBuilder(getServiceRoot() + "/identityProviders/" + id, this, null);
    }

    /**
     * Gets the collection of Applications objects
     *
     * @return the request builder for the collection of Applications objects
     */
    @Nonnull
    public com.microsoft.graph.requests.ApplicationCollectionRequestBuilder applications() {
        return new com.microsoft.graph.requests.ApplicationCollectionRequestBuilder(getServiceRoot() + "/applications", this, null);
    }

    /**
     * Gets a single Applications
     *
     * @param id the id of the Applications to retrieve
     * @return the request builder for the Applications object
     */
    @Nonnull
    public com.microsoft.graph.requests.ApplicationRequestBuilder applications(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ApplicationRequestBuilder(getServiceRoot() + "/applications/" + id, this, null);
    }

    /**
     * Gets the collection of CertificateBasedAuthConfiguration objects
     *
     * @return the request builder for the collection of CertificateBasedAuthConfiguration objects
     */
    @Nonnull
    public com.microsoft.graph.requests.CertificateBasedAuthConfigurationCollectionRequestBuilder certificateBasedAuthConfiguration() {
        return new com.microsoft.graph.requests.CertificateBasedAuthConfigurationCollectionRequestBuilder(getServiceRoot() + "/certificateBasedAuthConfiguration", this, null);
    }

    /**
     * Gets a single CertificateBasedAuthConfiguration
     *
     * @param id the id of the CertificateBasedAuthConfiguration to retrieve
     * @return the request builder for the CertificateBasedAuthConfiguration object
     */
    @Nonnull
    public com.microsoft.graph.requests.CertificateBasedAuthConfigurationRequestBuilder certificateBasedAuthConfiguration(@Nonnull final String id) {
        return new com.microsoft.graph.requests.CertificateBasedAuthConfigurationRequestBuilder(getServiceRoot() + "/certificateBasedAuthConfiguration/" + id, this, null);
    }

    /**
     * Gets the collection of Contacts objects
     *
     * @return the request builder for the collection of Contacts objects
     */
    @Nonnull
    public com.microsoft.graph.requests.OrgContactCollectionRequestBuilder contacts() {
        return new com.microsoft.graph.requests.OrgContactCollectionRequestBuilder(getServiceRoot() + "/contacts", this, null);
    }

    /**
     * Gets a single Contacts
     *
     * @param id the id of the Contacts to retrieve
     * @return the request builder for the Contacts object
     */
    @Nonnull
    public com.microsoft.graph.requests.OrgContactRequestBuilder contacts(@Nonnull final String id) {
        return new com.microsoft.graph.requests.OrgContactRequestBuilder(getServiceRoot() + "/contacts/" + id, this, null);
    }

    /**
     * Gets the collection of Contracts objects
     *
     * @return the request builder for the collection of Contracts objects
     */
    @Nonnull
    public com.microsoft.graph.requests.ContractCollectionRequestBuilder contracts() {
        return new com.microsoft.graph.requests.ContractCollectionRequestBuilder(getServiceRoot() + "/contracts", this, null);
    }

    /**
     * Gets a single Contracts
     *
     * @param id the id of the Contracts to retrieve
     * @return the request builder for the Contracts object
     */
    @Nonnull
    public com.microsoft.graph.requests.ContractRequestBuilder contracts(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ContractRequestBuilder(getServiceRoot() + "/contracts/" + id, this, null);
    }

    /**
     * Gets the collection of Devices objects
     *
     * @return the request builder for the collection of Devices objects
     */
    @Nonnull
    public com.microsoft.graph.requests.DeviceCollectionRequestBuilder devices() {
        return new com.microsoft.graph.requests.DeviceCollectionRequestBuilder(getServiceRoot() + "/devices", this, null);
    }

    /**
     * Gets a single Devices
     *
     * @param id the id of the Devices to retrieve
     * @return the request builder for the Devices object
     */
    @Nonnull
    public com.microsoft.graph.requests.DeviceRequestBuilder devices(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DeviceRequestBuilder(getServiceRoot() + "/devices/" + id, this, null);
    }

    /**
     * Gets the collection of DirectoryObjects objects
     *
     * @return the request builder for the collection of DirectoryObjects objects
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryObjectCollectionRequestBuilder directoryObjects() {
        return new com.microsoft.graph.requests.DirectoryObjectCollectionRequestBuilder(getServiceRoot() + "/directoryObjects", this, null);
    }

    /**
     * Gets a single DirectoryObjects
     *
     * @param id the id of the DirectoryObjects to retrieve
     * @return the request builder for the DirectoryObjects object
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryObjectRequestBuilder directoryObjects(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DirectoryObjectRequestBuilder(getServiceRoot() + "/directoryObjects/" + id, this, null);
    }

    /**
     * Gets the collection of DirectoryRoles objects
     *
     * @return the request builder for the collection of DirectoryRoles objects
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryRoleCollectionRequestBuilder directoryRoles() {
        return new com.microsoft.graph.requests.DirectoryRoleCollectionRequestBuilder(getServiceRoot() + "/directoryRoles", this, null);
    }

    /**
     * Gets a single DirectoryRoles
     *
     * @param id the id of the DirectoryRoles to retrieve
     * @return the request builder for the DirectoryRoles object
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryRoleRequestBuilder directoryRoles(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DirectoryRoleRequestBuilder(getServiceRoot() + "/directoryRoles/" + id, this, null);
    }

    /**
     * Gets the collection of DirectoryRoleTemplates objects
     *
     * @return the request builder for the collection of DirectoryRoleTemplates objects
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryRoleTemplateCollectionRequestBuilder directoryRoleTemplates() {
        return new com.microsoft.graph.requests.DirectoryRoleTemplateCollectionRequestBuilder(getServiceRoot() + "/directoryRoleTemplates", this, null);
    }

    /**
     * Gets a single DirectoryRoleTemplates
     *
     * @param id the id of the DirectoryRoleTemplates to retrieve
     * @return the request builder for the DirectoryRoleTemplates object
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryRoleTemplateRequestBuilder directoryRoleTemplates(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DirectoryRoleTemplateRequestBuilder(getServiceRoot() + "/directoryRoleTemplates/" + id, this, null);
    }

    /**
     * Gets the collection of DomainDnsRecords objects
     *
     * @return the request builder for the collection of DomainDnsRecords objects
     */
    @Nonnull
    public com.microsoft.graph.requests.DomainDnsRecordCollectionRequestBuilder domainDnsRecords() {
        return new com.microsoft.graph.requests.DomainDnsRecordCollectionRequestBuilder(getServiceRoot() + "/domainDnsRecords", this, null);
    }

    /**
     * Gets a single DomainDnsRecords
     *
     * @param id the id of the DomainDnsRecords to retrieve
     * @return the request builder for the DomainDnsRecords object
     */
    @Nonnull
    public com.microsoft.graph.requests.DomainDnsRecordRequestBuilder domainDnsRecords(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DomainDnsRecordRequestBuilder(getServiceRoot() + "/domainDnsRecords/" + id, this, null);
    }

    /**
     * Gets the collection of Domains objects
     *
     * @return the request builder for the collection of Domains objects
     */
    @Nonnull
    public com.microsoft.graph.requests.DomainCollectionRequestBuilder domains() {
        return new com.microsoft.graph.requests.DomainCollectionRequestBuilder(getServiceRoot() + "/domains", this, null);
    }

    /**
     * Gets a single Domains
     *
     * @param id the id of the Domains to retrieve
     * @return the request builder for the Domains object
     */
    @Nonnull
    public com.microsoft.graph.requests.DomainRequestBuilder domains(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DomainRequestBuilder(getServiceRoot() + "/domains/" + id, this, null);
    }

    /**
     * Gets the collection of Groups objects
     *
     * @return the request builder for the collection of Groups objects
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupCollectionRequestBuilder groups() {
        return new com.microsoft.graph.requests.GroupCollectionRequestBuilder(getServiceRoot() + "/groups", this, null);
    }

    /**
     * Gets a single Groups
     *
     * @param id the id of the Groups to retrieve
     * @return the request builder for the Groups object
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupRequestBuilder groups(@Nonnull final String id) {
        return new com.microsoft.graph.requests.GroupRequestBuilder(getServiceRoot() + "/groups/" + id, this, null);
    }

    /**
     * Gets the collection of GroupSettings objects
     *
     * @return the request builder for the collection of GroupSettings objects
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupSettingCollectionRequestBuilder groupSettings() {
        return new com.microsoft.graph.requests.GroupSettingCollectionRequestBuilder(getServiceRoot() + "/groupSettings", this, null);
    }

    /**
     * Gets a single GroupSettings
     *
     * @param id the id of the GroupSettings to retrieve
     * @return the request builder for the GroupSettings object
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupSettingRequestBuilder groupSettings(@Nonnull final String id) {
        return new com.microsoft.graph.requests.GroupSettingRequestBuilder(getServiceRoot() + "/groupSettings/" + id, this, null);
    }

    /**
     * Gets the collection of GroupSettingTemplates objects
     *
     * @return the request builder for the collection of GroupSettingTemplates objects
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupSettingTemplateCollectionRequestBuilder groupSettingTemplates() {
        return new com.microsoft.graph.requests.GroupSettingTemplateCollectionRequestBuilder(getServiceRoot() + "/groupSettingTemplates", this, null);
    }

    /**
     * Gets a single GroupSettingTemplates
     *
     * @param id the id of the GroupSettingTemplates to retrieve
     * @return the request builder for the GroupSettingTemplates object
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupSettingTemplateRequestBuilder groupSettingTemplates(@Nonnull final String id) {
        return new com.microsoft.graph.requests.GroupSettingTemplateRequestBuilder(getServiceRoot() + "/groupSettingTemplates/" + id, this, null);
    }

    /**
     * Gets the collection of Oauth2PermissionGrants objects
     *
     * @return the request builder for the collection of Oauth2PermissionGrants objects
     */
    @Nonnull
    public com.microsoft.graph.requests.OAuth2PermissionGrantCollectionRequestBuilder oauth2PermissionGrants() {
        return new com.microsoft.graph.requests.OAuth2PermissionGrantCollectionRequestBuilder(getServiceRoot() + "/oauth2PermissionGrants", this, null);
    }

    /**
     * Gets a single Oauth2PermissionGrants
     *
     * @param id the id of the Oauth2PermissionGrants to retrieve
     * @return the request builder for the Oauth2PermissionGrants object
     */
    @Nonnull
    public com.microsoft.graph.requests.OAuth2PermissionGrantRequestBuilder oauth2PermissionGrants(@Nonnull final String id) {
        return new com.microsoft.graph.requests.OAuth2PermissionGrantRequestBuilder(getServiceRoot() + "/oauth2PermissionGrants/" + id, this, null);
    }

    /**
     * Gets the collection of Organization objects
     *
     * @return the request builder for the collection of Organization objects
     */
    @Nonnull
    public com.microsoft.graph.requests.OrganizationCollectionRequestBuilder organization() {
        return new com.microsoft.graph.requests.OrganizationCollectionRequestBuilder(getServiceRoot() + "/organization", this, null);
    }

    /**
     * Gets a single Organization
     *
     * @param id the id of the Organization to retrieve
     * @return the request builder for the Organization object
     */
    @Nonnull
    public com.microsoft.graph.requests.OrganizationRequestBuilder organization(@Nonnull final String id) {
        return new com.microsoft.graph.requests.OrganizationRequestBuilder(getServiceRoot() + "/organization/" + id, this, null);
    }

    /**
     * Gets the collection of PermissionGrants objects
     *
     * @return the request builder for the collection of PermissionGrants objects
     */
    @Nonnull
    public com.microsoft.graph.requests.ResourceSpecificPermissionGrantCollectionRequestBuilder permissionGrants() {
        return new com.microsoft.graph.requests.ResourceSpecificPermissionGrantCollectionRequestBuilder(getServiceRoot() + "/permissionGrants", this, null);
    }

    /**
     * Gets a single PermissionGrants
     *
     * @param id the id of the PermissionGrants to retrieve
     * @return the request builder for the PermissionGrants object
     */
    @Nonnull
    public com.microsoft.graph.requests.ResourceSpecificPermissionGrantRequestBuilder permissionGrants(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ResourceSpecificPermissionGrantRequestBuilder(getServiceRoot() + "/permissionGrants/" + id, this, null);
    }

    /**
     * Gets the collection of ScopedRoleMemberships objects
     *
     * @return the request builder for the collection of ScopedRoleMemberships objects
     */
    @Nonnull
    public com.microsoft.graph.requests.ScopedRoleMembershipCollectionRequestBuilder scopedRoleMemberships() {
        return new com.microsoft.graph.requests.ScopedRoleMembershipCollectionRequestBuilder(getServiceRoot() + "/scopedRoleMemberships", this, null);
    }

    /**
     * Gets a single ScopedRoleMemberships
     *
     * @param id the id of the ScopedRoleMemberships to retrieve
     * @return the request builder for the ScopedRoleMemberships object
     */
    @Nonnull
    public com.microsoft.graph.requests.ScopedRoleMembershipRequestBuilder scopedRoleMemberships(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ScopedRoleMembershipRequestBuilder(getServiceRoot() + "/scopedRoleMemberships/" + id, this, null);
    }

    /**
     * Gets the collection of ServicePrincipals objects
     *
     * @return the request builder for the collection of ServicePrincipals objects
     */
    @Nonnull
    public com.microsoft.graph.requests.ServicePrincipalCollectionRequestBuilder servicePrincipals() {
        return new com.microsoft.graph.requests.ServicePrincipalCollectionRequestBuilder(getServiceRoot() + "/servicePrincipals", this, null);
    }

    /**
     * Gets a single ServicePrincipals
     *
     * @param id the id of the ServicePrincipals to retrieve
     * @return the request builder for the ServicePrincipals object
     */
    @Nonnull
    public com.microsoft.graph.requests.ServicePrincipalRequestBuilder servicePrincipals(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ServicePrincipalRequestBuilder(getServiceRoot() + "/servicePrincipals/" + id, this, null);
    }

    /**
     * Gets the collection of SubscribedSkus objects
     *
     * @return the request builder for the collection of SubscribedSkus objects
     */
    @Nonnull
    public com.microsoft.graph.requests.SubscribedSkuCollectionRequestBuilder subscribedSkus() {
        return new com.microsoft.graph.requests.SubscribedSkuCollectionRequestBuilder(getServiceRoot() + "/subscribedSkus", this, null);
    }

    /**
     * Gets a single SubscribedSkus
     *
     * @param id the id of the SubscribedSkus to retrieve
     * @return the request builder for the SubscribedSkus object
     */
    @Nonnull
    public com.microsoft.graph.requests.SubscribedSkuRequestBuilder subscribedSkus(@Nonnull final String id) {
        return new com.microsoft.graph.requests.SubscribedSkuRequestBuilder(getServiceRoot() + "/subscribedSkus/" + id, this, null);
    }

    /**
     * Gets the collection of Places objects
     *
     * @return the request builder for the collection of Places objects
     */
    @Nonnull
    public com.microsoft.graph.requests.PlaceCollectionRequestBuilder places() {
        return new com.microsoft.graph.requests.PlaceCollectionRequestBuilder(getServiceRoot() + "/places", this, null);
    }

    /**
     * Gets a single Places
     *
     * @param id the id of the Places to retrieve
     * @return the request builder for the Places object
     */
    @Nonnull
    public com.microsoft.graph.requests.PlaceRequestBuilder places(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PlaceRequestBuilder(getServiceRoot() + "/places/" + id, this, null);
    }

    /**
     * Gets the collection of Drives objects
     *
     * @return the request builder for the collection of Drives objects
     */
    @Nonnull
    public com.microsoft.graph.requests.DriveCollectionRequestBuilder drives() {
        return new com.microsoft.graph.requests.DriveCollectionRequestBuilder(getServiceRoot() + "/drives", this, null);
    }

    /**
     * Gets a single Drives
     *
     * @param id the id of the Drives to retrieve
     * @return the request builder for the Drives object
     */
    @Nonnull
    public com.microsoft.graph.requests.DriveRequestBuilder drives(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DriveRequestBuilder(getServiceRoot() + "/drives/" + id, this, null);
    }

    /**
     * Gets the collection of Shares objects
     *
     * @return the request builder for the collection of Shares objects
     */
    @Nonnull
    public com.microsoft.graph.requests.SharedDriveItemCollectionRequestBuilder shares() {
        return new com.microsoft.graph.requests.SharedDriveItemCollectionRequestBuilder(getServiceRoot() + "/shares", this, null);
    }

    /**
     * Gets a single Shares
     *
     * @param id the id of the Shares to retrieve
     * @return the request builder for the Shares object
     */
    @Nonnull
    public com.microsoft.graph.requests.SharedDriveItemRequestBuilder shares(@Nonnull final String id) {
        return new com.microsoft.graph.requests.SharedDriveItemRequestBuilder(getServiceRoot() + "/shares/" + id, this, null);
    }

    /**
     * Gets the collection of Sites objects
     *
     * @return the request builder for the collection of Sites objects
     */
    @Nonnull
    public com.microsoft.graph.requests.SiteCollectionRequestBuilder sites() {
        return new com.microsoft.graph.requests.SiteCollectionRequestBuilder(getServiceRoot() + "/sites", this, null);
    }

    /**
     * Gets a single Sites
     *
     * @param id the id of the Sites to retrieve
     * @return the request builder for the Sites object
     */
    @Nonnull
    public com.microsoft.graph.requests.SiteRequestBuilder sites(@Nonnull final String id) {
        return new com.microsoft.graph.requests.SiteRequestBuilder(getServiceRoot() + "/sites/" + id, this, null);
    }

    /**
     * Gets the collection of SchemaExtensions objects
     *
     * @return the request builder for the collection of SchemaExtensions objects
     */
    @Nonnull
    public com.microsoft.graph.requests.SchemaExtensionCollectionRequestBuilder schemaExtensions() {
        return new com.microsoft.graph.requests.SchemaExtensionCollectionRequestBuilder(getServiceRoot() + "/schemaExtensions", this, null);
    }

    /**
     * Gets a single SchemaExtensions
     *
     * @param id the id of the SchemaExtensions to retrieve
     * @return the request builder for the SchemaExtensions object
     */
    @Nonnull
    public com.microsoft.graph.requests.SchemaExtensionRequestBuilder schemaExtensions(@Nonnull final String id) {
        return new com.microsoft.graph.requests.SchemaExtensionRequestBuilder(getServiceRoot() + "/schemaExtensions/" + id, this, null);
    }

    /**
     * Gets the collection of GroupLifecyclePolicies objects
     *
     * @return the request builder for the collection of GroupLifecyclePolicies objects
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupLifecyclePolicyCollectionRequestBuilder groupLifecyclePolicies() {
        return new com.microsoft.graph.requests.GroupLifecyclePolicyCollectionRequestBuilder(getServiceRoot() + "/groupLifecyclePolicies", this, null);
    }

    /**
     * Gets a single GroupLifecyclePolicies
     *
     * @param id the id of the GroupLifecyclePolicies to retrieve
     * @return the request builder for the GroupLifecyclePolicies object
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupLifecyclePolicyRequestBuilder groupLifecyclePolicies(@Nonnull final String id) {
        return new com.microsoft.graph.requests.GroupLifecyclePolicyRequestBuilder(getServiceRoot() + "/groupLifecyclePolicies/" + id, this, null);
    }

    /**
     * Gets the collection of FilterOperators objects
     *
     * @return the request builder for the collection of FilterOperators objects
     */
    @Nonnull
    public com.microsoft.graph.requests.FilterOperatorSchemaCollectionRequestBuilder filterOperators() {
        return new com.microsoft.graph.requests.FilterOperatorSchemaCollectionRequestBuilder(getServiceRoot() + "/filterOperators", this, null);
    }

    /**
     * Gets a single FilterOperators
     *
     * @param id the id of the FilterOperators to retrieve
     * @return the request builder for the FilterOperators object
     */
    @Nonnull
    public com.microsoft.graph.requests.FilterOperatorSchemaRequestBuilder filterOperators(@Nonnull final String id) {
        return new com.microsoft.graph.requests.FilterOperatorSchemaRequestBuilder(getServiceRoot() + "/filterOperators/" + id, this, null);
    }

    /**
     * Gets the collection of Functions objects
     *
     * @return the request builder for the collection of Functions objects
     */
    @Nonnull
    public com.microsoft.graph.requests.AttributeMappingFunctionSchemaCollectionRequestBuilder functions() {
        return new com.microsoft.graph.requests.AttributeMappingFunctionSchemaCollectionRequestBuilder(getServiceRoot() + "/functions", this, null);
    }

    /**
     * Gets a single Functions
     *
     * @param id the id of the Functions to retrieve
     * @return the request builder for the Functions object
     */
    @Nonnull
    public com.microsoft.graph.requests.AttributeMappingFunctionSchemaRequestBuilder functions(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AttributeMappingFunctionSchemaRequestBuilder(getServiceRoot() + "/functions/" + id, this, null);
    }

    /**
     * Gets the collection of AgreementAcceptances objects
     *
     * @return the request builder for the collection of AgreementAcceptances objects
     */
    @Nonnull
    public com.microsoft.graph.requests.AgreementAcceptanceCollectionRequestBuilder agreementAcceptances() {
        return new com.microsoft.graph.requests.AgreementAcceptanceCollectionRequestBuilder(getServiceRoot() + "/agreementAcceptances", this, null);
    }

    /**
     * Gets a single AgreementAcceptances
     *
     * @param id the id of the AgreementAcceptances to retrieve
     * @return the request builder for the AgreementAcceptances object
     */
    @Nonnull
    public com.microsoft.graph.requests.AgreementAcceptanceRequestBuilder agreementAcceptances(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AgreementAcceptanceRequestBuilder(getServiceRoot() + "/agreementAcceptances/" + id, this, null);
    }

    /**
     * Gets the collection of Agreements objects
     *
     * @return the request builder for the collection of Agreements objects
     */
    @Nonnull
    public com.microsoft.graph.requests.AgreementCollectionRequestBuilder agreements() {
        return new com.microsoft.graph.requests.AgreementCollectionRequestBuilder(getServiceRoot() + "/agreements", this, null);
    }

    /**
     * Gets a single Agreements
     *
     * @param id the id of the Agreements to retrieve
     * @return the request builder for the Agreements object
     */
    @Nonnull
    public com.microsoft.graph.requests.AgreementRequestBuilder agreements(@Nonnull final String id) {
        return new com.microsoft.graph.requests.AgreementRequestBuilder(getServiceRoot() + "/agreements/" + id, this, null);
    }

    /**
     * Gets the collection of DataPolicyOperations objects
     *
     * @return the request builder for the collection of DataPolicyOperations objects
     */
    @Nonnull
    public com.microsoft.graph.requests.DataPolicyOperationCollectionRequestBuilder dataPolicyOperations() {
        return new com.microsoft.graph.requests.DataPolicyOperationCollectionRequestBuilder(getServiceRoot() + "/dataPolicyOperations", this, null);
    }

    /**
     * Gets a single DataPolicyOperations
     *
     * @param id the id of the DataPolicyOperations to retrieve
     * @return the request builder for the DataPolicyOperations object
     */
    @Nonnull
    public com.microsoft.graph.requests.DataPolicyOperationRequestBuilder dataPolicyOperations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DataPolicyOperationRequestBuilder(getServiceRoot() + "/dataPolicyOperations/" + id, this, null);
    }

    /**
     * Gets the collection of Subscriptions objects
     *
     * @return the request builder for the collection of Subscriptions objects
     */
    @Nonnull
    public com.microsoft.graph.requests.SubscriptionCollectionRequestBuilder subscriptions() {
        return new com.microsoft.graph.requests.SubscriptionCollectionRequestBuilder(getServiceRoot() + "/subscriptions", this, null);
    }

    /**
     * Gets a single Subscriptions
     *
     * @param id the id of the Subscriptions to retrieve
     * @return the request builder for the Subscriptions object
     */
    @Nonnull
    public com.microsoft.graph.requests.SubscriptionRequestBuilder subscriptions(@Nonnull final String id) {
        return new com.microsoft.graph.requests.SubscriptionRequestBuilder(getServiceRoot() + "/subscriptions/" + id, this, null);
    }

    /**
     * Gets the collection of Connections objects
     *
     * @return the request builder for the collection of Connections objects
     */
    @Nonnull
    public com.microsoft.graph.externalconnectors.requests.ExternalConnectionCollectionRequestBuilder connections() {
        return new com.microsoft.graph.externalconnectors.requests.ExternalConnectionCollectionRequestBuilder(getServiceRoot() + "/connections", this, null);
    }

    /**
     * Gets a single Connections
     *
     * @param id the id of the Connections to retrieve
     * @return the request builder for the Connections object
     */
    @Nonnull
    public com.microsoft.graph.externalconnectors.requests.ExternalConnectionRequestBuilder connections(@Nonnull final String id) {
        return new com.microsoft.graph.externalconnectors.requests.ExternalConnectionRequestBuilder(getServiceRoot() + "/connections/" + id, this, null);
    }

    /**
     * Gets the collection of Chats objects
     *
     * @return the request builder for the collection of Chats objects
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatCollectionRequestBuilder chats() {
        return new com.microsoft.graph.requests.ChatCollectionRequestBuilder(getServiceRoot() + "/chats", this, null);
    }

    /**
     * Gets a single Chats
     *
     * @param id the id of the Chats to retrieve
     * @return the request builder for the Chats object
     */
    @Nonnull
    public com.microsoft.graph.requests.ChatRequestBuilder chats(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ChatRequestBuilder(getServiceRoot() + "/chats/" + id, this, null);
    }

    /**
     * Gets the collection of Teams objects
     *
     * @return the request builder for the collection of Teams objects
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamCollectionRequestBuilder teams() {
        return new com.microsoft.graph.requests.TeamCollectionRequestBuilder(getServiceRoot() + "/teams", this, null);
    }

    /**
     * Gets a single Teams
     *
     * @param id the id of the Teams to retrieve
     * @return the request builder for the Teams object
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamRequestBuilder teams(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TeamRequestBuilder(getServiceRoot() + "/teams/" + id, this, null);
    }

    /**
     * Gets the collection of TeamsTemplates objects
     *
     * @return the request builder for the collection of TeamsTemplates objects
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsTemplateCollectionRequestBuilder teamsTemplates() {
        return new com.microsoft.graph.requests.TeamsTemplateCollectionRequestBuilder(getServiceRoot() + "/teamsTemplates", this, null);
    }

    /**
     * Gets a single TeamsTemplates
     *
     * @param id the id of the TeamsTemplates to retrieve
     * @return the request builder for the TeamsTemplates object
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsTemplateRequestBuilder teamsTemplates(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TeamsTemplateRequestBuilder(getServiceRoot() + "/teamsTemplates/" + id, this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the IdentityGovernance
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentityGovernanceRequestBuilder identityGovernance() {
        return new com.microsoft.graph.requests.IdentityGovernanceRequestBuilder(getServiceRoot() + "/identityGovernance", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the AuditLogRoot
     */
    @Nonnull
    public com.microsoft.graph.requests.AuditLogRootRequestBuilder auditLogs() {
        return new com.microsoft.graph.requests.AuditLogRootRequestBuilder(getServiceRoot() + "/auditLogs", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the ReportRoot
     */
    @Nonnull
    public com.microsoft.graph.requests.ReportRootRequestBuilder reports() {
        return new com.microsoft.graph.requests.ReportRootRequestBuilder(getServiceRoot() + "/reports", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the AuthenticationMethodsPolicy
     */
    @Nonnull
    public com.microsoft.graph.requests.AuthenticationMethodsPolicyRequestBuilder authenticationMethodsPolicy() {
        return new com.microsoft.graph.requests.AuthenticationMethodsPolicyRequestBuilder(getServiceRoot() + "/authenticationMethodsPolicy", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the SolutionsRoot
     */
    @Nonnull
    public com.microsoft.graph.requests.SolutionsRootRequestBuilder solutions() {
        return new com.microsoft.graph.requests.SolutionsRootRequestBuilder(getServiceRoot() + "/solutions", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the Privacy
     */
    @Nonnull
    public com.microsoft.graph.requests.PrivacyRequestBuilder privacy() {
        return new com.microsoft.graph.requests.PrivacyRequestBuilder(getServiceRoot() + "/privacy", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the Compliance
     */
    @Nonnull
    public com.microsoft.graph.requests.ComplianceRequestBuilder compliance() {
        return new com.microsoft.graph.requests.ComplianceRequestBuilder(getServiceRoot() + "/compliance", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the Security
     */
    @Nonnull
    public com.microsoft.graph.requests.SecurityRequestBuilder security() {
        return new com.microsoft.graph.requests.SecurityRequestBuilder(getServiceRoot() + "/security", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the IdentityContainer
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentityContainerRequestBuilder identity() {
        return new com.microsoft.graph.requests.IdentityContainerRequestBuilder(getServiceRoot() + "/identity", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the Directory
     */
    @Nonnull
    public com.microsoft.graph.requests.DirectoryRequestBuilder directory() {
        return new com.microsoft.graph.requests.DirectoryRequestBuilder(getServiceRoot() + "/directory", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the User
     */
    @Nonnull
    public com.microsoft.graph.requests.UserRequestBuilder me() {
        return new com.microsoft.graph.requests.UserRequestBuilder(getServiceRoot() + "/me", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the PolicyRoot
     */
    @Nonnull
    public com.microsoft.graph.requests.PolicyRootRequestBuilder policies() {
        return new com.microsoft.graph.requests.PolicyRootRequestBuilder(getServiceRoot() + "/policies", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the TenantRelationship
     */
    @Nonnull
    public com.microsoft.graph.requests.TenantRelationshipRequestBuilder tenantRelationships() {
        return new com.microsoft.graph.requests.TenantRelationshipRequestBuilder(getServiceRoot() + "/tenantRelationships", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the Admin
     */
    @Nonnull
    public com.microsoft.graph.requests.AdminRequestBuilder admin() {
        return new com.microsoft.graph.requests.AdminRequestBuilder(getServiceRoot() + "/admin", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the EducationRoot
     */
    @Nonnull
    public com.microsoft.graph.requests.EducationRootRequestBuilder education() {
        return new com.microsoft.graph.requests.EducationRootRequestBuilder(getServiceRoot() + "/education", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the RoleManagement
     */
    @Nonnull
    public com.microsoft.graph.requests.RoleManagementRequestBuilder roleManagement() {
        return new com.microsoft.graph.requests.RoleManagementRequestBuilder(getServiceRoot() + "/roleManagement", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the Drive
     */
    @Nonnull
    public com.microsoft.graph.requests.DriveRequestBuilder drive() {
        return new com.microsoft.graph.requests.DriveRequestBuilder(getServiceRoot() + "/drive", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the CloudCommunications
     */
    @Nonnull
    public com.microsoft.graph.requests.CloudCommunicationsRequestBuilder communications() {
        return new com.microsoft.graph.requests.CloudCommunicationsRequestBuilder(getServiceRoot() + "/communications", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the IdentityProtectionRoot
     */
    @Nonnull
    public com.microsoft.graph.requests.IdentityProtectionRootRequestBuilder identityProtection() {
        return new com.microsoft.graph.requests.IdentityProtectionRootRequestBuilder(getServiceRoot() + "/identityProtection", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the DeviceAppManagement
     */
    @Nonnull
    public com.microsoft.graph.requests.DeviceAppManagementRequestBuilder deviceAppManagement() {
        return new com.microsoft.graph.requests.DeviceAppManagementRequestBuilder(getServiceRoot() + "/deviceAppManagement", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the DeviceManagement
     */
    @Nonnull
    public com.microsoft.graph.requests.DeviceManagementRequestBuilder deviceManagement() {
        return new com.microsoft.graph.requests.DeviceManagementRequestBuilder(getServiceRoot() + "/deviceManagement", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the SearchEntity
     */
    @Nonnull
    public com.microsoft.graph.requests.SearchEntityRequestBuilder search() {
        return new com.microsoft.graph.requests.SearchEntityRequestBuilder(getServiceRoot() + "/search", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the Planner
     */
    @Nonnull
    public com.microsoft.graph.requests.PlannerRequestBuilder planner() {
        return new com.microsoft.graph.requests.PlannerRequestBuilder(getServiceRoot() + "/planner", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the Print
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintRequestBuilder print() {
        return new com.microsoft.graph.requests.PrintRequestBuilder(getServiceRoot() + "/print", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the External
     */
    @Nonnull
    public com.microsoft.graph.externalconnectors.requests.ExternalRequestBuilder external() {
        return new com.microsoft.graph.externalconnectors.requests.ExternalRequestBuilder(getServiceRoot() + "/external", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the AppCatalogs
     */
    @Nonnull
    public com.microsoft.graph.requests.AppCatalogsRequestBuilder appCatalogs() {
        return new com.microsoft.graph.requests.AppCatalogsRequestBuilder(getServiceRoot() + "/appCatalogs", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the Teamwork
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamworkRequestBuilder teamwork() {
        return new com.microsoft.graph.requests.TeamworkRequestBuilder(getServiceRoot() + "/teamwork", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the InformationProtection
     */
    @Nonnull
    public com.microsoft.graph.requests.InformationProtectionRequestBuilder informationProtection() {
        return new com.microsoft.graph.requests.InformationProtectionRequestBuilder(getServiceRoot() + "/informationProtection", this, null);
    }

    /**
     * Gets the GraphServiceRequestBuilder
     *
     * @return the EmployeeExperience
     */
    @Nonnull
    public com.microsoft.graph.requests.EmployeeExperienceRequestBuilder employeeExperience() {
        return new com.microsoft.graph.requests.EmployeeExperienceRequestBuilder(getServiceRoot() + "/employeeExperience", this, null);
    }
}
