// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityApiConnector;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Api Connector Request.
 */
public class IdentityApiConnectorRequest extends BaseRequest<IdentityApiConnector> {
	
    /**
     * The request for the IdentityApiConnector
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityApiConnectorRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityApiConnector.class);
    }

    /**
     * Gets the IdentityApiConnector from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityApiConnector> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IdentityApiConnector from the service
     *
     * @return the IdentityApiConnector from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityApiConnector get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityApiConnector> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IdentityApiConnector delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IdentityApiConnector with a source
     *
     * @param sourceIdentityApiConnector the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityApiConnector> patchAsync(@Nonnull final IdentityApiConnector sourceIdentityApiConnector) {
        return sendAsync(HttpMethod.PATCH, sourceIdentityApiConnector);
    }

    /**
     * Patches this IdentityApiConnector with a source
     *
     * @param sourceIdentityApiConnector the source object with updates
     * @return the updated IdentityApiConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityApiConnector patch(@Nonnull final IdentityApiConnector sourceIdentityApiConnector) throws ClientException {
        return send(HttpMethod.PATCH, sourceIdentityApiConnector);
    }

    /**
     * Creates a IdentityApiConnector with a new object
     *
     * @param newIdentityApiConnector the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityApiConnector> postAsync(@Nonnull final IdentityApiConnector newIdentityApiConnector) {
        return sendAsync(HttpMethod.POST, newIdentityApiConnector);
    }

    /**
     * Creates a IdentityApiConnector with a new object
     *
     * @param newIdentityApiConnector the new object to create
     * @return the created IdentityApiConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityApiConnector post(@Nonnull final IdentityApiConnector newIdentityApiConnector) throws ClientException {
        return send(HttpMethod.POST, newIdentityApiConnector);
    }

    /**
     * Creates a IdentityApiConnector with a new object
     *
     * @param newIdentityApiConnector the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityApiConnector> putAsync(@Nonnull final IdentityApiConnector newIdentityApiConnector) {
        return sendAsync(HttpMethod.PUT, newIdentityApiConnector);
    }

    /**
     * Creates a IdentityApiConnector with a new object
     *
     * @param newIdentityApiConnector the object to create/update
     * @return the created IdentityApiConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityApiConnector put(@Nonnull final IdentityApiConnector newIdentityApiConnector) throws ClientException {
        return send(HttpMethod.PUT, newIdentityApiConnector);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IdentityApiConnectorRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IdentityApiConnectorRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

