// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.IdentityUserFlowAttributeAssignmentSetOrderRequest;
import com.microsoft.graph.models.IdentityUserFlowAttributeAssignment;
import com.microsoft.graph.models.AssignmentOrder;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.IdentityUserFlowAttributeAssignmentSetOrderParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity User Flow Attribute Assignment Set Order Request Builder.
 */
public class IdentityUserFlowAttributeAssignmentSetOrderRequestBuilder extends BaseActionRequestBuilder<IdentityUserFlowAttributeAssignment> {

    /**
     * The request builder for this IdentityUserFlowAttributeAssignmentSetOrder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityUserFlowAttributeAssignmentSetOrderRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private IdentityUserFlowAttributeAssignmentSetOrderParameterSet body;
    /**
     * The request builder for this IdentityUserFlowAttributeAssignmentSetOrder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public IdentityUserFlowAttributeAssignmentSetOrderRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final IdentityUserFlowAttributeAssignmentSetOrderParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the IdentityUserFlowAttributeAssignmentSetOrderRequest
     *
     * @param requestOptions the options for the request
     * @return the IdentityUserFlowAttributeAssignmentSetOrderRequest instance
     */
    @Nonnull
    public IdentityUserFlowAttributeAssignmentSetOrderRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IdentityUserFlowAttributeAssignmentSetOrderRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IdentityUserFlowAttributeAssignmentSetOrderRequest instance
     */
    @Nonnull
    public IdentityUserFlowAttributeAssignmentSetOrderRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final IdentityUserFlowAttributeAssignmentSetOrderRequest request = new IdentityUserFlowAttributeAssignmentSetOrderRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
