// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.InternetExplorerMode;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Internet Explorer Mode Request.
 */
public class InternetExplorerModeRequest extends BaseRequest<InternetExplorerMode> {
	
    /**
     * The request for the InternetExplorerMode
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public InternetExplorerModeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, InternetExplorerMode.class);
    }

    /**
     * Gets the InternetExplorerMode from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InternetExplorerMode> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the InternetExplorerMode from the service
     *
     * @return the InternetExplorerMode from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InternetExplorerMode get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InternetExplorerMode> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public InternetExplorerMode delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this InternetExplorerMode with a source
     *
     * @param sourceInternetExplorerMode the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InternetExplorerMode> patchAsync(@Nonnull final InternetExplorerMode sourceInternetExplorerMode) {
        return sendAsync(HttpMethod.PATCH, sourceInternetExplorerMode);
    }

    /**
     * Patches this InternetExplorerMode with a source
     *
     * @param sourceInternetExplorerMode the source object with updates
     * @return the updated InternetExplorerMode
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InternetExplorerMode patch(@Nonnull final InternetExplorerMode sourceInternetExplorerMode) throws ClientException {
        return send(HttpMethod.PATCH, sourceInternetExplorerMode);
    }

    /**
     * Creates a InternetExplorerMode with a new object
     *
     * @param newInternetExplorerMode the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InternetExplorerMode> postAsync(@Nonnull final InternetExplorerMode newInternetExplorerMode) {
        return sendAsync(HttpMethod.POST, newInternetExplorerMode);
    }

    /**
     * Creates a InternetExplorerMode with a new object
     *
     * @param newInternetExplorerMode the new object to create
     * @return the created InternetExplorerMode
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InternetExplorerMode post(@Nonnull final InternetExplorerMode newInternetExplorerMode) throws ClientException {
        return send(HttpMethod.POST, newInternetExplorerMode);
    }

    /**
     * Creates a InternetExplorerMode with a new object
     *
     * @param newInternetExplorerMode the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InternetExplorerMode> putAsync(@Nonnull final InternetExplorerMode newInternetExplorerMode) {
        return sendAsync(HttpMethod.PUT, newInternetExplorerMode);
    }

    /**
     * Creates a InternetExplorerMode with a new object
     *
     * @param newInternetExplorerMode the object to create/update
     * @return the created InternetExplorerMode
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InternetExplorerMode put(@Nonnull final InternetExplorerMode newInternetExplorerMode) throws ClientException {
        return send(HttpMethod.PUT, newInternetExplorerMode);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public InternetExplorerModeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public InternetExplorerModeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

