// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LearningSelfInitiatedCourse;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Learning Self Initiated Course Request.
 */
public class LearningSelfInitiatedCourseRequest extends BaseRequest<LearningSelfInitiatedCourse> {
	
    /**
     * The request for the LearningSelfInitiatedCourse
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LearningSelfInitiatedCourseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LearningSelfInitiatedCourse.class);
    }

    /**
     * Gets the LearningSelfInitiatedCourse from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningSelfInitiatedCourse> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LearningSelfInitiatedCourse from the service
     *
     * @return the LearningSelfInitiatedCourse from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningSelfInitiatedCourse get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningSelfInitiatedCourse> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LearningSelfInitiatedCourse delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LearningSelfInitiatedCourse with a source
     *
     * @param sourceLearningSelfInitiatedCourse the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningSelfInitiatedCourse> patchAsync(@Nonnull final LearningSelfInitiatedCourse sourceLearningSelfInitiatedCourse) {
        return sendAsync(HttpMethod.PATCH, sourceLearningSelfInitiatedCourse);
    }

    /**
     * Patches this LearningSelfInitiatedCourse with a source
     *
     * @param sourceLearningSelfInitiatedCourse the source object with updates
     * @return the updated LearningSelfInitiatedCourse
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningSelfInitiatedCourse patch(@Nonnull final LearningSelfInitiatedCourse sourceLearningSelfInitiatedCourse) throws ClientException {
        return send(HttpMethod.PATCH, sourceLearningSelfInitiatedCourse);
    }

    /**
     * Creates a LearningSelfInitiatedCourse with a new object
     *
     * @param newLearningSelfInitiatedCourse the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningSelfInitiatedCourse> postAsync(@Nonnull final LearningSelfInitiatedCourse newLearningSelfInitiatedCourse) {
        return sendAsync(HttpMethod.POST, newLearningSelfInitiatedCourse);
    }

    /**
     * Creates a LearningSelfInitiatedCourse with a new object
     *
     * @param newLearningSelfInitiatedCourse the new object to create
     * @return the created LearningSelfInitiatedCourse
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningSelfInitiatedCourse post(@Nonnull final LearningSelfInitiatedCourse newLearningSelfInitiatedCourse) throws ClientException {
        return send(HttpMethod.POST, newLearningSelfInitiatedCourse);
    }

    /**
     * Creates a LearningSelfInitiatedCourse with a new object
     *
     * @param newLearningSelfInitiatedCourse the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LearningSelfInitiatedCourse> putAsync(@Nonnull final LearningSelfInitiatedCourse newLearningSelfInitiatedCourse) {
        return sendAsync(HttpMethod.PUT, newLearningSelfInitiatedCourse);
    }

    /**
     * Creates a LearningSelfInitiatedCourse with a new object
     *
     * @param newLearningSelfInitiatedCourse the object to create/update
     * @return the created LearningSelfInitiatedCourse
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LearningSelfInitiatedCourse put(@Nonnull final LearningSelfInitiatedCourse newLearningSelfInitiatedCourse) throws ClientException {
        return send(HttpMethod.PUT, newLearningSelfInitiatedCourse);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LearningSelfInitiatedCourseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LearningSelfInitiatedCourseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

