// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.ManagedAppRegistration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ManagedAppRegistrationCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ManagedAppRegistrationCollectionWithReferencesPage;
import com.microsoft.graph.requests.ManagedAppRegistrationCollectionResponse;
import com.microsoft.graph.models.ManagedAppRegistration;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed App Registration Collection With References Page.
 */
public class ManagedAppRegistrationCollectionWithReferencesPage extends BaseCollectionPage<ManagedAppRegistration, ManagedAppRegistrationCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for ManagedAppRegistration
     *
     * @param response the serialized ManagedAppRegistrationCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public ManagedAppRegistrationCollectionWithReferencesPage(@Nonnull final ManagedAppRegistrationCollectionResponse response, @Nullable final ManagedAppRegistrationCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for ManagedAppRegistration
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public ManagedAppRegistrationCollectionWithReferencesPage(@Nonnull final java.util.List<ManagedAppRegistration> pageContents, @Nullable final ManagedAppRegistrationCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
