// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ServicePrincipal;
import com.microsoft.graph.models.OAuth2PermissionGrant;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionWithReferencesPage;
import com.microsoft.graph.requests.OAuth2PermissionGrantCollectionResponse;
import com.microsoft.graph.models.OAuth2PermissionGrant;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the OAuth2Permission Grant Collection With References Page.
 */
public class OAuth2PermissionGrantCollectionWithReferencesPage extends BaseCollectionPage<OAuth2PermissionGrant, OAuth2PermissionGrantCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for OAuth2PermissionGrant
     *
     * @param response the serialized OAuth2PermissionGrantCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public OAuth2PermissionGrantCollectionWithReferencesPage(@Nonnull final OAuth2PermissionGrantCollectionResponse response, @Nullable final OAuth2PermissionGrantCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for OAuth2PermissionGrant
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public OAuth2PermissionGrantCollectionWithReferencesPage(@Nonnull final java.util.List<OAuth2PermissionGrant> pageContents, @Nullable final OAuth2PermissionGrantCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
