// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OfficeGraphInsights;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Office Graph Insights Request Builder.
 */
public class OfficeGraphInsightsRequestBuilder extends BaseRequestBuilder<OfficeGraphInsights> {

    /**
     * The request builder for the OfficeGraphInsights
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OfficeGraphInsightsRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the OfficeGraphInsightsRequest instance
     */
    @Nonnull
    public OfficeGraphInsightsRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the OfficeGraphInsightsRequest instance
     */
    @Nonnull
    public OfficeGraphInsightsRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.OfficeGraphInsightsRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the SharedInsight collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.SharedInsightCollectionRequestBuilder shared() {
        return new com.microsoft.graph.requests.SharedInsightCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("shared"), getClient(), null);
    }

    /**
     * Gets a request builder for the SharedInsight item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.SharedInsightRequestBuilder shared(@Nonnull final String id) {
        return new com.microsoft.graph.requests.SharedInsightRequestBuilder(getRequestUrlWithAdditionalSegment("shared") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Trending collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TrendingCollectionRequestBuilder trending() {
        return new com.microsoft.graph.requests.TrendingCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("trending"), getClient(), null);
    }

    /**
     * Gets a request builder for the Trending item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TrendingRequestBuilder trending(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TrendingRequestBuilder(getRequestUrlWithAdditionalSegment("trending") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UsedInsight collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.UsedInsightCollectionRequestBuilder used() {
        return new com.microsoft.graph.requests.UsedInsightCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("used"), getClient(), null);
    }

    /**
     * Gets a request builder for the UsedInsight item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.UsedInsightRequestBuilder used(@Nonnull final String id) {
        return new com.microsoft.graph.requests.UsedInsightRequestBuilder(getRequestUrlWithAdditionalSegment("used") + "/" + id, getClient(), null);
    }
}
