// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Print;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Request Builder.
 */
public class PrintRequestBuilder extends BaseRequestBuilder<Print> {

    /**
     * The request builder for the Print
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the PrintRequest instance
     */
    @Nonnull
    public PrintRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the PrintRequest instance
     */
    @Nonnull
    public PrintRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.PrintRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the PrintConnector collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintConnectorCollectionRequestBuilder connectors() {
        return new com.microsoft.graph.requests.PrintConnectorCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("connectors"), getClient(), null);
    }

    /**
     * Gets a request builder for the PrintConnector item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintConnectorRequestBuilder connectors(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrintConnectorRequestBuilder(getRequestUrlWithAdditionalSegment("connectors") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PrintOperation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintOperationCollectionRequestBuilder operations() {
        return new com.microsoft.graph.requests.PrintOperationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("operations"), getClient(), null);
    }

    /**
     * Gets a request builder for the PrintOperation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintOperationRequestBuilder operations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrintOperationRequestBuilder(getRequestUrlWithAdditionalSegment("operations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Printer collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrinterCollectionRequestBuilder printers() {
        return new com.microsoft.graph.requests.PrinterCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("printers"), getClient(), null);
    }

    /**
     * Gets a request builder for the Printer item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrinterRequestBuilder printers(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrinterRequestBuilder(getRequestUrlWithAdditionalSegment("printers") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PrintService collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintServiceCollectionRequestBuilder services() {
        return new com.microsoft.graph.requests.PrintServiceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("services"), getClient(), null);
    }

    /**
     * Gets a request builder for the PrintService item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintServiceRequestBuilder services(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrintServiceRequestBuilder(getRequestUrlWithAdditionalSegment("services") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PrinterShare collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrinterShareCollectionRequestBuilder shares() {
        return new com.microsoft.graph.requests.PrinterShareCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("shares"), getClient(), null);
    }

    /**
     * Gets a request builder for the PrinterShare item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrinterShareRequestBuilder shares(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrinterShareRequestBuilder(getRequestUrlWithAdditionalSegment("shares") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PrintTaskDefinition collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintTaskDefinitionCollectionRequestBuilder taskDefinitions() {
        return new com.microsoft.graph.requests.PrintTaskDefinitionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("taskDefinitions"), getClient(), null);
    }

    /**
     * Gets a request builder for the PrintTaskDefinition item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.PrintTaskDefinitionRequestBuilder taskDefinitions(@Nonnull final String id) {
        return new com.microsoft.graph.requests.PrintTaskDefinitionRequestBuilder(getRequestUrlWithAdditionalSegment("taskDefinitions") + "/" + id, getClient(), null);
    }
}
