// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrintUsageByUser;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Usage By User Request.
 */
public class PrintUsageByUserRequest extends BaseRequest<PrintUsageByUser> {
	
    /**
     * The request for the PrintUsageByUser
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintUsageByUserRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintUsageByUser.class);
    }

    /**
     * Gets the PrintUsageByUser from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByUser> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrintUsageByUser from the service
     *
     * @return the PrintUsageByUser from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintUsageByUser get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByUser> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrintUsageByUser delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintUsageByUser with a source
     *
     * @param sourcePrintUsageByUser the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByUser> patchAsync(@Nonnull final PrintUsageByUser sourcePrintUsageByUser) {
        return sendAsync(HttpMethod.PATCH, sourcePrintUsageByUser);
    }

    /**
     * Patches this PrintUsageByUser with a source
     *
     * @param sourcePrintUsageByUser the source object with updates
     * @return the updated PrintUsageByUser
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintUsageByUser patch(@Nonnull final PrintUsageByUser sourcePrintUsageByUser) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintUsageByUser);
    }

    /**
     * Creates a PrintUsageByUser with a new object
     *
     * @param newPrintUsageByUser the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByUser> postAsync(@Nonnull final PrintUsageByUser newPrintUsageByUser) {
        return sendAsync(HttpMethod.POST, newPrintUsageByUser);
    }

    /**
     * Creates a PrintUsageByUser with a new object
     *
     * @param newPrintUsageByUser the new object to create
     * @return the created PrintUsageByUser
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintUsageByUser post(@Nonnull final PrintUsageByUser newPrintUsageByUser) throws ClientException {
        return send(HttpMethod.POST, newPrintUsageByUser);
    }

    /**
     * Creates a PrintUsageByUser with a new object
     *
     * @param newPrintUsageByUser the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByUser> putAsync(@Nonnull final PrintUsageByUser newPrintUsageByUser) {
        return sendAsync(HttpMethod.PUT, newPrintUsageByUser);
    }

    /**
     * Creates a PrintUsageByUser with a new object
     *
     * @param newPrintUsageByUser the object to create/update
     * @return the created PrintUsageByUser
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintUsageByUser put(@Nonnull final PrintUsageByUser newPrintUsageByUser) throws ClientException {
        return send(HttpMethod.PUT, newPrintUsageByUser);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrintUsageByUserRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrintUsageByUserRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

