// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Print;
import com.microsoft.graph.models.Printer;
import com.microsoft.graph.models.PrintCertificateSigningRequest;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.PrinterCollectionRequestBuilder;
import com.microsoft.graph.requests.PrinterRequestBuilder;
import com.microsoft.graph.requests.PrinterCollectionRequest;
import com.microsoft.graph.requests.PrinterCreateRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.PrinterCreateParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Collection Request Builder.
 */
public class PrinterCollectionRequestBuilder extends BaseCollectionRequestBuilder<Printer, PrinterRequestBuilder, PrinterCollectionResponse, PrinterCollectionPage, PrinterCollectionRequest> {

    /**
     * The request builder for this collection of Print
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrinterCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterRequestBuilder.class, PrinterCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public PrinterCreateRequestBuilder create(@Nonnull final PrinterCreateParameterSet parameters) {
        return new PrinterCreateRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.create"), getClient(), null, parameters);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
