// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SharepointSettings;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Sharepoint Settings Request.
 */
public class SharepointSettingsRequest extends BaseRequest<SharepointSettings> {
	
    /**
     * The request for the SharepointSettings
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SharepointSettingsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SharepointSettings.class);
    }

    /**
     * Gets the SharepointSettings from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharepointSettings> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SharepointSettings from the service
     *
     * @return the SharepointSettings from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharepointSettings get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharepointSettings> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SharepointSettings delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SharepointSettings with a source
     *
     * @param sourceSharepointSettings the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharepointSettings> patchAsync(@Nonnull final SharepointSettings sourceSharepointSettings) {
        return sendAsync(HttpMethod.PATCH, sourceSharepointSettings);
    }

    /**
     * Patches this SharepointSettings with a source
     *
     * @param sourceSharepointSettings the source object with updates
     * @return the updated SharepointSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharepointSettings patch(@Nonnull final SharepointSettings sourceSharepointSettings) throws ClientException {
        return send(HttpMethod.PATCH, sourceSharepointSettings);
    }

    /**
     * Creates a SharepointSettings with a new object
     *
     * @param newSharepointSettings the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharepointSettings> postAsync(@Nonnull final SharepointSettings newSharepointSettings) {
        return sendAsync(HttpMethod.POST, newSharepointSettings);
    }

    /**
     * Creates a SharepointSettings with a new object
     *
     * @param newSharepointSettings the new object to create
     * @return the created SharepointSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharepointSettings post(@Nonnull final SharepointSettings newSharepointSettings) throws ClientException {
        return send(HttpMethod.POST, newSharepointSettings);
    }

    /**
     * Creates a SharepointSettings with a new object
     *
     * @param newSharepointSettings the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharepointSettings> putAsync(@Nonnull final SharepointSettings newSharepointSettings) {
        return sendAsync(HttpMethod.PUT, newSharepointSettings);
    }

    /**
     * Creates a SharepointSettings with a new object
     *
     * @param newSharepointSettings the object to create/update
     * @return the created SharepointSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharepointSettings put(@Nonnull final SharepointSettings newSharepointSettings) throws ClientException {
        return send(HttpMethod.PUT, newSharepointSettings);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SharepointSettingsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SharepointSettingsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

