// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UnifiedRoleManagementPolicyEnablementRule;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Management Policy Enablement Rule Request.
 */
public class UnifiedRoleManagementPolicyEnablementRuleRequest extends BaseRequest<UnifiedRoleManagementPolicyEnablementRule> {
	
    /**
     * The request for the UnifiedRoleManagementPolicyEnablementRule
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleManagementPolicyEnablementRuleRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleManagementPolicyEnablementRule.class);
    }

    /**
     * Gets the UnifiedRoleManagementPolicyEnablementRule from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyEnablementRule> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UnifiedRoleManagementPolicyEnablementRule from the service
     *
     * @return the UnifiedRoleManagementPolicyEnablementRule from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyEnablementRule get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyEnablementRule> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UnifiedRoleManagementPolicyEnablementRule delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UnifiedRoleManagementPolicyEnablementRule with a source
     *
     * @param sourceUnifiedRoleManagementPolicyEnablementRule the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyEnablementRule> patchAsync(@Nonnull final UnifiedRoleManagementPolicyEnablementRule sourceUnifiedRoleManagementPolicyEnablementRule) {
        return sendAsync(HttpMethod.PATCH, sourceUnifiedRoleManagementPolicyEnablementRule);
    }

    /**
     * Patches this UnifiedRoleManagementPolicyEnablementRule with a source
     *
     * @param sourceUnifiedRoleManagementPolicyEnablementRule the source object with updates
     * @return the updated UnifiedRoleManagementPolicyEnablementRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyEnablementRule patch(@Nonnull final UnifiedRoleManagementPolicyEnablementRule sourceUnifiedRoleManagementPolicyEnablementRule) throws ClientException {
        return send(HttpMethod.PATCH, sourceUnifiedRoleManagementPolicyEnablementRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyEnablementRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyEnablementRule the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyEnablementRule> postAsync(@Nonnull final UnifiedRoleManagementPolicyEnablementRule newUnifiedRoleManagementPolicyEnablementRule) {
        return sendAsync(HttpMethod.POST, newUnifiedRoleManagementPolicyEnablementRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyEnablementRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyEnablementRule the new object to create
     * @return the created UnifiedRoleManagementPolicyEnablementRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyEnablementRule post(@Nonnull final UnifiedRoleManagementPolicyEnablementRule newUnifiedRoleManagementPolicyEnablementRule) throws ClientException {
        return send(HttpMethod.POST, newUnifiedRoleManagementPolicyEnablementRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyEnablementRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyEnablementRule the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleManagementPolicyEnablementRule> putAsync(@Nonnull final UnifiedRoleManagementPolicyEnablementRule newUnifiedRoleManagementPolicyEnablementRule) {
        return sendAsync(HttpMethod.PUT, newUnifiedRoleManagementPolicyEnablementRule);
    }

    /**
     * Creates a UnifiedRoleManagementPolicyEnablementRule with a new object
     *
     * @param newUnifiedRoleManagementPolicyEnablementRule the object to create/update
     * @return the created UnifiedRoleManagementPolicyEnablementRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleManagementPolicyEnablementRule put(@Nonnull final UnifiedRoleManagementPolicyEnablementRule newUnifiedRoleManagementPolicyEnablementRule) throws ClientException {
        return send(HttpMethod.PUT, newUnifiedRoleManagementPolicyEnablementRule);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleManagementPolicyEnablementRuleRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleManagementPolicyEnablementRuleRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

