// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsAppHealthDevicePerformance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics App Health Device Performance Request.
 */
public class UserExperienceAnalyticsAppHealthDevicePerformanceRequest extends BaseRequest<UserExperienceAnalyticsAppHealthDevicePerformance> {
	
    /**
     * The request for the UserExperienceAnalyticsAppHealthDevicePerformance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsAppHealthDevicePerformanceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsAppHealthDevicePerformance.class);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthDevicePerformance from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDevicePerformance> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthDevicePerformance from the service
     *
     * @return the UserExperienceAnalyticsAppHealthDevicePerformance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDevicePerformance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDevicePerformance> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDevicePerformance delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthDevicePerformance with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthDevicePerformance the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDevicePerformance> patchAsync(@Nonnull final UserExperienceAnalyticsAppHealthDevicePerformance sourceUserExperienceAnalyticsAppHealthDevicePerformance) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthDevicePerformance);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthDevicePerformance with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthDevicePerformance the source object with updates
     * @return the updated UserExperienceAnalyticsAppHealthDevicePerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDevicePerformance patch(@Nonnull final UserExperienceAnalyticsAppHealthDevicePerformance sourceUserExperienceAnalyticsAppHealthDevicePerformance) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthDevicePerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthDevicePerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthDevicePerformance the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDevicePerformance> postAsync(@Nonnull final UserExperienceAnalyticsAppHealthDevicePerformance newUserExperienceAnalyticsAppHealthDevicePerformance) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsAppHealthDevicePerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthDevicePerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthDevicePerformance the new object to create
     * @return the created UserExperienceAnalyticsAppHealthDevicePerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDevicePerformance post(@Nonnull final UserExperienceAnalyticsAppHealthDevicePerformance newUserExperienceAnalyticsAppHealthDevicePerformance) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsAppHealthDevicePerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthDevicePerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthDevicePerformance the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthDevicePerformance> putAsync(@Nonnull final UserExperienceAnalyticsAppHealthDevicePerformance newUserExperienceAnalyticsAppHealthDevicePerformance) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthDevicePerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthDevicePerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthDevicePerformance the object to create/update
     * @return the created UserExperienceAnalyticsAppHealthDevicePerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthDevicePerformance put(@Nonnull final UserExperienceAnalyticsAppHealthDevicePerformance newUserExperienceAnalyticsAppHealthDevicePerformance) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthDevicePerformance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthDevicePerformanceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthDevicePerformanceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

