// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsAppHealthOSVersionPerformance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics App Health OSVersion Performance Request.
 */
public class UserExperienceAnalyticsAppHealthOSVersionPerformanceRequest extends BaseRequest<UserExperienceAnalyticsAppHealthOSVersionPerformance> {
	
    /**
     * The request for the UserExperienceAnalyticsAppHealthOSVersionPerformance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsAppHealthOSVersionPerformanceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsAppHealthOSVersionPerformance.class);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthOSVersionPerformance from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthOSVersionPerformance> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsAppHealthOSVersionPerformance from the service
     *
     * @return the UserExperienceAnalyticsAppHealthOSVersionPerformance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthOSVersionPerformance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthOSVersionPerformance> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthOSVersionPerformance delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthOSVersionPerformance with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthOSVersionPerformance the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthOSVersionPerformance> patchAsync(@Nonnull final UserExperienceAnalyticsAppHealthOSVersionPerformance sourceUserExperienceAnalyticsAppHealthOSVersionPerformance) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthOSVersionPerformance);
    }

    /**
     * Patches this UserExperienceAnalyticsAppHealthOSVersionPerformance with a source
     *
     * @param sourceUserExperienceAnalyticsAppHealthOSVersionPerformance the source object with updates
     * @return the updated UserExperienceAnalyticsAppHealthOSVersionPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthOSVersionPerformance patch(@Nonnull final UserExperienceAnalyticsAppHealthOSVersionPerformance sourceUserExperienceAnalyticsAppHealthOSVersionPerformance) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsAppHealthOSVersionPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthOSVersionPerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthOSVersionPerformance the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthOSVersionPerformance> postAsync(@Nonnull final UserExperienceAnalyticsAppHealthOSVersionPerformance newUserExperienceAnalyticsAppHealthOSVersionPerformance) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsAppHealthOSVersionPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthOSVersionPerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthOSVersionPerformance the new object to create
     * @return the created UserExperienceAnalyticsAppHealthOSVersionPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthOSVersionPerformance post(@Nonnull final UserExperienceAnalyticsAppHealthOSVersionPerformance newUserExperienceAnalyticsAppHealthOSVersionPerformance) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsAppHealthOSVersionPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthOSVersionPerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthOSVersionPerformance the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsAppHealthOSVersionPerformance> putAsync(@Nonnull final UserExperienceAnalyticsAppHealthOSVersionPerformance newUserExperienceAnalyticsAppHealthOSVersionPerformance) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthOSVersionPerformance);
    }

    /**
     * Creates a UserExperienceAnalyticsAppHealthOSVersionPerformance with a new object
     *
     * @param newUserExperienceAnalyticsAppHealthOSVersionPerformance the object to create/update
     * @return the created UserExperienceAnalyticsAppHealthOSVersionPerformance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsAppHealthOSVersionPerformance put(@Nonnull final UserExperienceAnalyticsAppHealthOSVersionPerformance newUserExperienceAnalyticsAppHealthOSVersionPerformance) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsAppHealthOSVersionPerformance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthOSVersionPerformanceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsAppHealthOSVersionPerformanceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

