// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsDeviceStartupHistory;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Device Startup History Request.
 */
public class UserExperienceAnalyticsDeviceStartupHistoryRequest extends BaseRequest<UserExperienceAnalyticsDeviceStartupHistory> {
	
    /**
     * The request for the UserExperienceAnalyticsDeviceStartupHistory
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsDeviceStartupHistoryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsDeviceStartupHistory.class);
    }

    /**
     * Gets the UserExperienceAnalyticsDeviceStartupHistory from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupHistory> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsDeviceStartupHistory from the service
     *
     * @return the UserExperienceAnalyticsDeviceStartupHistory from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupHistory get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupHistory> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupHistory delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsDeviceStartupHistory with a source
     *
     * @param sourceUserExperienceAnalyticsDeviceStartupHistory the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupHistory> patchAsync(@Nonnull final UserExperienceAnalyticsDeviceStartupHistory sourceUserExperienceAnalyticsDeviceStartupHistory) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsDeviceStartupHistory);
    }

    /**
     * Patches this UserExperienceAnalyticsDeviceStartupHistory with a source
     *
     * @param sourceUserExperienceAnalyticsDeviceStartupHistory the source object with updates
     * @return the updated UserExperienceAnalyticsDeviceStartupHistory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupHistory patch(@Nonnull final UserExperienceAnalyticsDeviceStartupHistory sourceUserExperienceAnalyticsDeviceStartupHistory) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsDeviceStartupHistory);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupHistory with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupHistory the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupHistory> postAsync(@Nonnull final UserExperienceAnalyticsDeviceStartupHistory newUserExperienceAnalyticsDeviceStartupHistory) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsDeviceStartupHistory);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupHistory with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupHistory the new object to create
     * @return the created UserExperienceAnalyticsDeviceStartupHistory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupHistory post(@Nonnull final UserExperienceAnalyticsDeviceStartupHistory newUserExperienceAnalyticsDeviceStartupHistory) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsDeviceStartupHistory);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupHistory with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupHistory the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupHistory> putAsync(@Nonnull final UserExperienceAnalyticsDeviceStartupHistory newUserExperienceAnalyticsDeviceStartupHistory) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsDeviceStartupHistory);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupHistory with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupHistory the object to create/update
     * @return the created UserExperienceAnalyticsDeviceStartupHistory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupHistory put(@Nonnull final UserExperienceAnalyticsDeviceStartupHistory newUserExperienceAnalyticsDeviceStartupHistory) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsDeviceStartupHistory);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsDeviceStartupHistoryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsDeviceStartupHistoryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

