// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsDeviceStartupProcess;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Device Startup Process Request.
 */
public class UserExperienceAnalyticsDeviceStartupProcessRequest extends BaseRequest<UserExperienceAnalyticsDeviceStartupProcess> {
	
    /**
     * The request for the UserExperienceAnalyticsDeviceStartupProcess
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsDeviceStartupProcessRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsDeviceStartupProcess.class);
    }

    /**
     * Gets the UserExperienceAnalyticsDeviceStartupProcess from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcess> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsDeviceStartupProcess from the service
     *
     * @return the UserExperienceAnalyticsDeviceStartupProcess from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcess get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcess> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcess delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsDeviceStartupProcess with a source
     *
     * @param sourceUserExperienceAnalyticsDeviceStartupProcess the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcess> patchAsync(@Nonnull final UserExperienceAnalyticsDeviceStartupProcess sourceUserExperienceAnalyticsDeviceStartupProcess) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsDeviceStartupProcess);
    }

    /**
     * Patches this UserExperienceAnalyticsDeviceStartupProcess with a source
     *
     * @param sourceUserExperienceAnalyticsDeviceStartupProcess the source object with updates
     * @return the updated UserExperienceAnalyticsDeviceStartupProcess
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcess patch(@Nonnull final UserExperienceAnalyticsDeviceStartupProcess sourceUserExperienceAnalyticsDeviceStartupProcess) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsDeviceStartupProcess);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupProcess with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupProcess the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcess> postAsync(@Nonnull final UserExperienceAnalyticsDeviceStartupProcess newUserExperienceAnalyticsDeviceStartupProcess) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsDeviceStartupProcess);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupProcess with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupProcess the new object to create
     * @return the created UserExperienceAnalyticsDeviceStartupProcess
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcess post(@Nonnull final UserExperienceAnalyticsDeviceStartupProcess newUserExperienceAnalyticsDeviceStartupProcess) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsDeviceStartupProcess);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupProcess with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupProcess the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsDeviceStartupProcess> putAsync(@Nonnull final UserExperienceAnalyticsDeviceStartupProcess newUserExperienceAnalyticsDeviceStartupProcess) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsDeviceStartupProcess);
    }

    /**
     * Creates a UserExperienceAnalyticsDeviceStartupProcess with a new object
     *
     * @param newUserExperienceAnalyticsDeviceStartupProcess the object to create/update
     * @return the created UserExperienceAnalyticsDeviceStartupProcess
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsDeviceStartupProcess put(@Nonnull final UserExperienceAnalyticsDeviceStartupProcess newUserExperienceAnalyticsDeviceStartupProcess) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsDeviceStartupProcess);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsDeviceStartupProcessRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsDeviceStartupProcessRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

