// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.VoiceAuthenticationMethodConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Voice Authentication Method Configuration Request.
 */
public class VoiceAuthenticationMethodConfigurationRequest extends BaseRequest<VoiceAuthenticationMethodConfiguration> {
	
    /**
     * The request for the VoiceAuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VoiceAuthenticationMethodConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, VoiceAuthenticationMethodConfiguration.class);
    }

    /**
     * Gets the VoiceAuthenticationMethodConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VoiceAuthenticationMethodConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the VoiceAuthenticationMethodConfiguration from the service
     *
     * @return the VoiceAuthenticationMethodConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VoiceAuthenticationMethodConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VoiceAuthenticationMethodConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public VoiceAuthenticationMethodConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this VoiceAuthenticationMethodConfiguration with a source
     *
     * @param sourceVoiceAuthenticationMethodConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VoiceAuthenticationMethodConfiguration> patchAsync(@Nonnull final VoiceAuthenticationMethodConfiguration sourceVoiceAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceVoiceAuthenticationMethodConfiguration);
    }

    /**
     * Patches this VoiceAuthenticationMethodConfiguration with a source
     *
     * @param sourceVoiceAuthenticationMethodConfiguration the source object with updates
     * @return the updated VoiceAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VoiceAuthenticationMethodConfiguration patch(@Nonnull final VoiceAuthenticationMethodConfiguration sourceVoiceAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceVoiceAuthenticationMethodConfiguration);
    }

    /**
     * Creates a VoiceAuthenticationMethodConfiguration with a new object
     *
     * @param newVoiceAuthenticationMethodConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VoiceAuthenticationMethodConfiguration> postAsync(@Nonnull final VoiceAuthenticationMethodConfiguration newVoiceAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.POST, newVoiceAuthenticationMethodConfiguration);
    }

    /**
     * Creates a VoiceAuthenticationMethodConfiguration with a new object
     *
     * @param newVoiceAuthenticationMethodConfiguration the new object to create
     * @return the created VoiceAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VoiceAuthenticationMethodConfiguration post(@Nonnull final VoiceAuthenticationMethodConfiguration newVoiceAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.POST, newVoiceAuthenticationMethodConfiguration);
    }

    /**
     * Creates a VoiceAuthenticationMethodConfiguration with a new object
     *
     * @param newVoiceAuthenticationMethodConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VoiceAuthenticationMethodConfiguration> putAsync(@Nonnull final VoiceAuthenticationMethodConfiguration newVoiceAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PUT, newVoiceAuthenticationMethodConfiguration);
    }

    /**
     * Creates a VoiceAuthenticationMethodConfiguration with a new object
     *
     * @param newVoiceAuthenticationMethodConfiguration the object to create/update
     * @return the created VoiceAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VoiceAuthenticationMethodConfiguration put(@Nonnull final VoiceAuthenticationMethodConfiguration newVoiceAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newVoiceAuthenticationMethodConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public VoiceAuthenticationMethodConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public VoiceAuthenticationMethodConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

