// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WindowsUniversalAppXContainedApp;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Universal App XContained App Request.
 */
public class WindowsUniversalAppXContainedAppRequest extends BaseRequest<WindowsUniversalAppXContainedApp> {
	
    /**
     * The request for the WindowsUniversalAppXContainedApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsUniversalAppXContainedAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsUniversalAppXContainedApp.class);
    }

    /**
     * Gets the WindowsUniversalAppXContainedApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsUniversalAppXContainedApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WindowsUniversalAppXContainedApp from the service
     *
     * @return the WindowsUniversalAppXContainedApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsUniversalAppXContainedApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsUniversalAppXContainedApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WindowsUniversalAppXContainedApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsUniversalAppXContainedApp with a source
     *
     * @param sourceWindowsUniversalAppXContainedApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsUniversalAppXContainedApp> patchAsync(@Nonnull final WindowsUniversalAppXContainedApp sourceWindowsUniversalAppXContainedApp) {
        return sendAsync(HttpMethod.PATCH, sourceWindowsUniversalAppXContainedApp);
    }

    /**
     * Patches this WindowsUniversalAppXContainedApp with a source
     *
     * @param sourceWindowsUniversalAppXContainedApp the source object with updates
     * @return the updated WindowsUniversalAppXContainedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsUniversalAppXContainedApp patch(@Nonnull final WindowsUniversalAppXContainedApp sourceWindowsUniversalAppXContainedApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsUniversalAppXContainedApp);
    }

    /**
     * Creates a WindowsUniversalAppXContainedApp with a new object
     *
     * @param newWindowsUniversalAppXContainedApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsUniversalAppXContainedApp> postAsync(@Nonnull final WindowsUniversalAppXContainedApp newWindowsUniversalAppXContainedApp) {
        return sendAsync(HttpMethod.POST, newWindowsUniversalAppXContainedApp);
    }

    /**
     * Creates a WindowsUniversalAppXContainedApp with a new object
     *
     * @param newWindowsUniversalAppXContainedApp the new object to create
     * @return the created WindowsUniversalAppXContainedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsUniversalAppXContainedApp post(@Nonnull final WindowsUniversalAppXContainedApp newWindowsUniversalAppXContainedApp) throws ClientException {
        return send(HttpMethod.POST, newWindowsUniversalAppXContainedApp);
    }

    /**
     * Creates a WindowsUniversalAppXContainedApp with a new object
     *
     * @param newWindowsUniversalAppXContainedApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WindowsUniversalAppXContainedApp> putAsync(@Nonnull final WindowsUniversalAppXContainedApp newWindowsUniversalAppXContainedApp) {
        return sendAsync(HttpMethod.PUT, newWindowsUniversalAppXContainedApp);
    }

    /**
     * Creates a WindowsUniversalAppXContainedApp with a new object
     *
     * @param newWindowsUniversalAppXContainedApp the object to create/update
     * @return the created WindowsUniversalAppXContainedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WindowsUniversalAppXContainedApp put(@Nonnull final WindowsUniversalAppXContainedApp newWindowsUniversalAppXContainedApp) throws ClientException {
        return send(HttpMethod.PUT, newWindowsUniversalAppXContainedApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WindowsUniversalAppXContainedAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WindowsUniversalAppXContainedAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

