// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookRangeSort;
import com.microsoft.graph.models.WorkbookSortField;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Sort Request.
 */
public class WorkbookRangeSortRequest extends BaseRequest<WorkbookRangeSort> {
	
    /**
     * The request for the WorkbookRangeSort
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookRangeSortRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookRangeSort.class);
    }

    /**
     * Gets the WorkbookRangeSort from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeSort> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookRangeSort from the service
     *
     * @return the WorkbookRangeSort from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeSort get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeSort> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookRangeSort delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookRangeSort with a source
     *
     * @param sourceWorkbookRangeSort the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeSort> patchAsync(@Nonnull final WorkbookRangeSort sourceWorkbookRangeSort) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookRangeSort);
    }

    /**
     * Patches this WorkbookRangeSort with a source
     *
     * @param sourceWorkbookRangeSort the source object with updates
     * @return the updated WorkbookRangeSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeSort patch(@Nonnull final WorkbookRangeSort sourceWorkbookRangeSort) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookRangeSort);
    }

    /**
     * Creates a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeSort> postAsync(@Nonnull final WorkbookRangeSort newWorkbookRangeSort) {
        return sendAsync(HttpMethod.POST, newWorkbookRangeSort);
    }

    /**
     * Creates a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the new object to create
     * @return the created WorkbookRangeSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeSort post(@Nonnull final WorkbookRangeSort newWorkbookRangeSort) throws ClientException {
        return send(HttpMethod.POST, newWorkbookRangeSort);
    }

    /**
     * Creates a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookRangeSort> putAsync(@Nonnull final WorkbookRangeSort newWorkbookRangeSort) {
        return sendAsync(HttpMethod.PUT, newWorkbookRangeSort);
    }

    /**
     * Creates a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the object to create/update
     * @return the created WorkbookRangeSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookRangeSort put(@Nonnull final WorkbookRangeSort newWorkbookRangeSort) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookRangeSort);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRangeSortRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookRangeSortRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

