// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookTable;
import com.microsoft.graph.models.WorkbookTableColumn;
import com.microsoft.graph.models.WorkbookRange;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.WorkbookTableColumnCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableColumnRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableColumnCollectionRequest;
import com.microsoft.graph.requests.WorkbookTableColumnAddRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableColumnCountRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableColumnItemAtRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.WorkbookTableColumnAddParameterSet;
import com.microsoft.graph.models.WorkbookTableColumnItemAtParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Table Column Collection Request Builder.
 */
public class WorkbookTableColumnCollectionRequestBuilder extends BaseCollectionRequestBuilder<WorkbookTableColumn, WorkbookTableColumnRequestBuilder, WorkbookTableColumnCollectionResponse, WorkbookTableColumnCollectionPage, WorkbookTableColumnCollectionRequest> {

    /**
     * The request builder for this collection of WorkbookTable
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookTableColumnCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookTableColumnRequestBuilder.class, WorkbookTableColumnCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookTableColumnAddRequestBuilder add(@Nonnull final WorkbookTableColumnAddParameterSet parameters) {
        return new WorkbookTableColumnAddRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.add"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public WorkbookTableColumnCountRequestBuilder count() {
        return new WorkbookTableColumnCountRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.count"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookTableColumnItemAtRequestBuilder itemAt(@Nonnull final WorkbookTableColumnItemAtParameterSet parameters) {
        return new WorkbookTableColumnItemAtRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.itemAt"), getClient(), null, parameters);
    }
}
