// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.HostCookie;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.HostCookieCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.HostCookieCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.HostCookieCollectionResponse;
import com.microsoft.graph.security.models.HostCookie;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Cookie Collection With References Page.
 */
public class HostCookieCollectionWithReferencesPage extends BaseCollectionPage<HostCookie, HostCookieCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for HostCookie
     *
     * @param response the serialized HostCookieCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public HostCookieCollectionWithReferencesPage(@Nonnull final HostCookieCollectionResponse response, @Nullable final HostCookieCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for HostCookie
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public HostCookieCollectionWithReferencesPage(@Nonnull final java.util.List<HostCookie> pageContents, @Nullable final HostCookieCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
