// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.GoogleCloudLocationType;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Google Cloud Resource Evidence.
 */
public class GoogleCloudResourceEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Location.
     * The zone or region where the resource is located.
     */
    @SerializedName(value = "location", alternate = {"Location"})
    @Expose
	@Nullable
    public String location;

    /**
     * The Location Type.
     * The type of location. Possible values are: unknown, regional, zonal, global, unknownFutureValue.
     */
    @SerializedName(value = "locationType", alternate = {"LocationType"})
    @Expose
	@Nullable
    public GoogleCloudLocationType locationType;

    /**
     * The Project Id.
     * The Google project ID as defined by the user.
     */
    @SerializedName(value = "projectId", alternate = {"ProjectId"})
    @Expose
	@Nullable
    public String projectId;

    /**
     * The Project Number.
     * The project number assigned by Google.
     */
    @SerializedName(value = "projectNumber", alternate = {"ProjectNumber"})
    @Expose
	@Nullable
    public Long projectNumber;

    /**
     * The Resource Name.
     * The name of the resource.
     */
    @SerializedName(value = "resourceName", alternate = {"ResourceName"})
    @Expose
	@Nullable
    public String resourceName;

    /**
     * The Resource Type.
     * The type of the resource.
     */
    @SerializedName(value = "resourceType", alternate = {"ResourceType"})
    @Expose
	@Nullable
    public String resourceType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
