// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Registry Key Evidence.
 */
public class RegistryKeyEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Registry Hive.
     * Registry hive of the key that the recorded action was applied to.
     */
    @SerializedName(value = "registryHive", alternate = {"RegistryHive"})
    @Expose
	@Nullable
    public String registryHive;

    /**
     * The Registry Key.
     * Registry key that the recorded action was applied to.
     */
    @SerializedName(value = "registryKey", alternate = {"RegistryKey"})
    @Expose
	@Nullable
    public String registryKey;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
