// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Case;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Case Request.
 */
public class CaseRequest extends BaseRequest<Case> {
	
    /**
     * The request for the Case
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public CaseRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends Case> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the Case
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CaseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Case.class);
    }

    /**
     * Gets the Case from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Case> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Case from the service
     *
     * @return the Case from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Case get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Case> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Case delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Case with a source
     *
     * @param sourceCase the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Case> patchAsync(@Nonnull final Case sourceCase) {
        return sendAsync(HttpMethod.PATCH, sourceCase);
    }

    /**
     * Patches this Case with a source
     *
     * @param sourceCase the source object with updates
     * @return the updated Case
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Case patch(@Nonnull final Case sourceCase) throws ClientException {
        return send(HttpMethod.PATCH, sourceCase);
    }

    /**
     * Creates a Case with a new object
     *
     * @param newCase the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Case> postAsync(@Nonnull final Case newCase) {
        return sendAsync(HttpMethod.POST, newCase);
    }

    /**
     * Creates a Case with a new object
     *
     * @param newCase the new object to create
     * @return the created Case
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Case post(@Nonnull final Case newCase) throws ClientException {
        return send(HttpMethod.POST, newCase);
    }

    /**
     * Creates a Case with a new object
     *
     * @param newCase the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Case> putAsync(@Nonnull final Case newCase) {
        return sendAsync(HttpMethod.PUT, newCase);
    }

    /**
     * Creates a Case with a new object
     *
     * @param newCase the object to create/update
     * @return the created Case
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Case put(@Nonnull final Case newCase) throws ClientException {
        return send(HttpMethod.PUT, newCase);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CaseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CaseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

