// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;
import com.microsoft.graph.security.requests.EdiscoveryCaseCloseRequest;
import com.microsoft.graph.security.models.EdiscoveryCase;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Case Close Request Builder.
 */
public class EdiscoveryCaseCloseRequestBuilder extends BaseActionRequestBuilder<EdiscoveryCase> {

    /**
     * The request builder for this EdiscoveryCaseClose
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryCaseCloseRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the EdiscoveryCaseCloseRequest
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryCaseCloseRequest instance
     */
    @Nonnull
    public EdiscoveryCaseCloseRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the EdiscoveryCaseCloseRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryCaseCloseRequest instance
     */
    @Nonnull
    public EdiscoveryCaseCloseRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EdiscoveryCaseCloseRequest request = new EdiscoveryCaseCloseRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
