// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;
import com.microsoft.graph.security.requests.EdiscoveryCaseSettingsResetToDefaultRequest;
import com.microsoft.graph.security.models.EdiscoveryCaseSettings;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Case Settings Reset To Default Request Builder.
 */
public class EdiscoveryCaseSettingsResetToDefaultRequestBuilder extends BaseActionRequestBuilder<EdiscoveryCaseSettings> {

    /**
     * The request builder for this EdiscoveryCaseSettingsResetToDefault
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryCaseSettingsResetToDefaultRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the EdiscoveryCaseSettingsResetToDefaultRequest
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryCaseSettingsResetToDefaultRequest instance
     */
    @Nonnull
    public EdiscoveryCaseSettingsResetToDefaultRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the EdiscoveryCaseSettingsResetToDefaultRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryCaseSettingsResetToDefaultRequest instance
     */
    @Nonnull
    public EdiscoveryCaseSettingsResetToDefaultRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EdiscoveryCaseSettingsResetToDefaultRequest request = new EdiscoveryCaseSettingsResetToDefaultRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
